/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.ProcessHandlerClient;
import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.google.common.base.Charsets;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class ContributorHandler {
    public static Map<String, Contributor> contributors = new LinkedHashMap<String, Contributor>();
    public static boolean successfulLoad = false;
    private static DLThread thread;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ContributorHandler());
        thread = new DLThread();
        thread.start();
        IProcess process = new IProcess(){

            public void updateProcess() {
                if (thread.isFinished()) {
                    thread = null;
                    ContributorHandler.readFile();
                    successfulLoad = true;
                    ContributorHandler.loadContributorConfig();
                    LogHelper.dev("Read Contributors File");
                } else if (thread.isFailed()) {
                    thread = null;
                    LogHelper.dev("Contributors File Download Failed");
                }
            }

            public boolean isDead() {
                return thread == null;
            }
        };
        if (EffectiveSide.get().isClient()) {
            ProcessHandlerClient.addProcess((IProcess)process);
        } else {
            ProcessHandler.addProcess((IProcess)process);
        }
    }

    public static boolean isPlayerContributor(PlayerEntity player) {
        return contributors.containsKey(player.func_200200_C_()) && contributors.get(player.func_200200_C_()).isUserValid(player);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            for (String contribName : contributors.keySet()) {
                for (String name : BrandonsCore.proxy.getMCServer().func_71213_z()) {
                    if (!name.equals(contribName)) continue;
                    Contributor contributor = contributors.get(contribName);
                }
            }
        }
    }

    private static void readFile() {
        File cFile = new File(FileHandler.brandon3055Folder, "contributors.json");
        if (!cFile.exists()) {
            LogHelper.error("Could not find contributors file");
            return;
        }
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(cFile));
            reader.setLenient(true);
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                Contributor contributor = new Contributor();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (name.equals("name")) {
                        contributor.name = reader.nextString();
                        continue;
                    }
                    if (name.equals("ign")) {
                        contributor.ign = reader.nextString();
                        continue;
                    }
                    if (name.equals("contribution")) {
                        contributor.setContribution(reader.nextString());
                        continue;
                    }
                    if (name.equals("details")) {
                        contributor.setDetails(reader.nextString());
                        continue;
                    }
                    if (name.equals("website")) {
                        contributor.website = reader.nextString();
                        continue;
                    }
                    if (!name.equals("contributionLevel")) continue;
                    contributor.setContributionLevel(reader.nextInt());
                }
                contributors.put(contributor.ign, contributor);
                reader.endObject();
            }
            reader.endArray();
            reader.close();
            cFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadContributorConfig() {
        try {
            File file = new File(FileHandler.brandon3055Folder, "contributor_settings.json");
            if (!file.exists()) {
                return;
            }
            JsonReader reader = new JsonReader((Reader)new FileReader(file));
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                reader.beginArray();
                boolean wings = reader.nextBoolean();
                boolean badge = reader.nextBoolean();
                boolean lbadge = reader.nextBoolean();
                if (contributors.containsKey(name)) {
                    ContributorHandler.contributors.get((Object)name).contributorWingsEnabled = wings;
                    ContributorHandler.contributors.get((Object)name).patreonBadgeEnabled = badge;
                    ContributorHandler.contributors.get((Object)name).lolnetBadgeEnabled = lbadge;
                }
                reader.endArray();
            }
            reader.endObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveContributorConfig() {
        try {
            File file = new File(FileHandler.brandon3055Folder, "contributor_settings.json");
            if (!file.exists()) {
                file.createNewFile();
            }
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.beginObject();
            for (String name : contributors.keySet()) {
                writer.name(name);
                writer.beginArray();
                writer.value(ContributorHandler.contributors.get((Object)name).contributorWingsEnabled);
                writer.value(ContributorHandler.contributors.get((Object)name).patreonBadgeEnabled);
                writer.value(ContributorHandler.contributors.get((Object)name).lolnetBadgeEnabled);
                writer.endArray();
            }
            writer.endObject();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Contributor {
        public String name;
        public String ign;
        public String contribution = "";
        public String details = "";
        public String website;
        private int contributionLevel;
        public boolean contributorWingsEnabled = true;
        public boolean patreonBadgeEnabled = true;
        private boolean validated = false;
        private boolean isValid;
        public boolean hasWings = false;
        public boolean isPatreonSupporter = false;
        public boolean lolnetBadgeEnabled = true;
        public boolean isLolnetContributor = false;

        public boolean isUserValid(PlayerEntity player) {
            if (player == null) {
                return false;
            }
            if (!this.validated) {
                this.isValid = !UUID.nameUUIDFromBytes(("OfflinePlayer:" + player.func_200200_C_()).getBytes(Charsets.UTF_8)).equals(player.func_110124_au());
                this.validated = true;
            }
            return this.isValid;
        }

        public void setContribution(String contribution) {
            this.contribution = contribution;
            if (contribution.toLowerCase(Locale.ENGLISH).contains("lolnet")) {
                this.isLolnetContributor = true;
            }
            if (contribution.toLowerCase(Locale.ENGLISH).contains("patreon")) {
                this.isPatreonSupporter = true;
            }
        }

        public void setDetails(String details) {
            this.details = details;
            if (details.toLowerCase(Locale.ENGLISH).contains("lolnet")) {
                this.isLolnetContributor = true;
            }
        }

        public void setContributionLevel(int contributionLevel) {
            this.contributionLevel = contributionLevel;
            if (contributionLevel >= 1) {
                this.hasWings = true;
            }
        }

        public String toString() {
            return "[Contributor: " + this.name + ", Contribution: " + this.contribution + ", Details: " + this.details + ", Website: " + this.website + "]";
        }
    }

    public static class DLThread
    extends Thread {
        private boolean finished = false;
        private boolean failed = false;

        public DLThread() {
            super("DE Contributors DL Thread");
        }

        @Override
        public void run() {
            super.run();
            try {
                File cFile = new File(FileHandler.brandon3055Folder, "contributors.json");
                FileHandler.downloadFile((String)"http://www.brandon3055.com/json/DEContributors.json", (File)cFile);
                this.finished = true;
            }
            catch (Exception e) {
                LogHelper.error("Failed to download contributors list");
                this.failed = true;
                e.printStackTrace();
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

