/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.projectile;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.damage.DraconicIndirectEntityDamage;
import com.brandon3055.draconicevolution.api.damage.IDraconicDamage;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.lib.ProjectileAntiImmunityDamage;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class DraconicArrowEntity
extends AbstractArrowEntity {
    private static final DataParameter<Integer> ID_EFFECT_COLOR = EntityDataManager.func_187226_a(DraconicArrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private Potion potion = Potions.field_185229_a;
    private final Set<EffectInstance> effects = Sets.newHashSet();
    private boolean fixedColor;
    private static final DataParameter<Integer> SPECTRAL_TIME = EntityDataManager.func_187226_a(DraconicArrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> TECH_LEVEL = EntityDataManager.func_187226_a(DraconicArrowEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> PENETRATION = EntityDataManager.func_187226_a(DraconicArrowEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> GRAV_COMPENSATION = EntityDataManager.func_187226_a(DraconicArrowEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> INIT_VELOCITY = EntityDataManager.func_187226_a(DraconicArrowEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> PROJ_ANTI_IMMUNE = EntityDataManager.func_187226_a(DraconicArrowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int blockPenetration = 0;

    public DraconicArrowEntity(EntityType<? extends DraconicArrowEntity> entityType, World world) {
        super(entityType, world);
    }

    public DraconicArrowEntity(World world, double xPos, double yPos, double zPos) {
        super(DEContent.draconicArrow, xPos, yPos, zPos, world);
    }

    public DraconicArrowEntity(World world, LivingEntity shooter) {
        super(DEContent.draconicArrow, shooter, world);
    }

    public void setSpectral(int spectralTime) {
        this.field_70180_af.func_187227_b(SPECTRAL_TIME, (Object)spectralTime);
    }

    public int getSpectralTime() {
        return (Integer)this.field_70180_af.func_187225_a(SPECTRAL_TIME);
    }

    public void setTechLevel(TechLevel techLevel) {
        this.field_70180_af.func_187227_b(TECH_LEVEL, (Object)((byte)techLevel.index));
    }

    public void setPenetration(float penetration) {
        int penCount = 0;
        while (penetration > this.field_70146_Z.nextFloat()) {
            ++penCount;
            penetration = (float)((double)penetration - 0.25);
        }
        this.field_70180_af.func_187227_b(PENETRATION, (Object)((byte)Math.min(penCount, 127)));
    }

    public void setProjectileImmuneOverride(boolean value) {
        this.field_70180_af.func_187227_b(PROJ_ANTI_IMMUNE, (Object)value);
    }

    public boolean getProjectileImmuneOverride() {
        return (Boolean)this.field_70180_af.func_187225_a(PROJ_ANTI_IMMUNE);
    }

    public void setGravComp(float gravComp) {
        this.field_70180_af.func_187227_b(GRAV_COMPENSATION, (Object)Float.valueOf(gravComp));
    }

    public void func_70186_c(double p_70186_1_, double p_70186_3_, double p_70186_5_, float speed, float p_70186_8_) {
        super.func_70186_c(p_70186_1_, p_70186_3_, p_70186_5_, speed, p_70186_8_);
        this.field_70180_af.func_187227_b(INIT_VELOCITY, (Object)Float.valueOf((float)this.func_213322_ci().func_72433_c()));
    }

    public void func_234612_a_(Entity p_234612_1_, float p_234612_2_, float p_234612_3_, float p_234612_4_, float speed, float p_234612_6_) {
        super.func_234612_a_(p_234612_1_, p_234612_2_, p_234612_3_, p_234612_4_, speed, p_234612_6_);
        this.field_70180_af.func_187227_b(INIT_VELOCITY, (Object)Float.valueOf((float)this.func_213322_ci().func_72433_c()));
    }

    public void func_70071_h_() {
        this.superTick();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && !this.effects.isEmpty() && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)0);
            this.potion = Potions.field_185229_a;
            this.effects.clear();
            this.field_70180_af.func_187227_b(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    private void superTick() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        if (!this.field_234611_d_) {
            this.field_234611_d_ = this.func_234615_h_();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
        boolean flag = this.func_203047_q();
        Vector3d vector3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)DraconicArrowEntity.func_213296_b((Vector3d)vector3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = this.func_233580_cy_())).isAir((IBlockReader)this.field_70170_p, blockpos) || flag || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            Vector3d vector3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vector3d1)) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.field_70254_i && !flag) {
            if (this.field_195056_av != blockstate && this.func_234593_u_()) {
                this.func_234594_z_();
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_225516_i_();
            }
            ++this.field_184552_b;
        } else {
            Vector3d vector3d3;
            this.field_184552_b = 0;
            Vector3d vector3d2 = this.func_213303_ch();
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d2, vector3d3 = vector3d2.func_178787_e(vector3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vector3d3 = raytraceresult.func_216347_e();
            }
            while (!this.field_70128_L) {
                EntityRayTraceResult entityraytraceresult = this.func_213866_a(vector3d2, vector3d3);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity entity1 = this.func_234616_v_();
                    if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)raytraceresult)) {
                    this.func_70227_a((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
                if (entityraytraceresult == null || this.func_213874_s() <= 0 && (Byte)this.field_70180_af.func_187225_a(PENETRATION) <= 0) break;
                raytraceresult = null;
            }
            vector3d = this.func_213322_ci();
            double d3 = vector3d.field_72450_a;
            double d4 = vector3d.field_72448_b;
            double d0 = vector3d.field_72449_c;
            if (this.func_70241_g()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_() + d3 * (double)i / 4.0, this.func_226278_cu_() + d4 * (double)i / 4.0, this.func_226281_cx_() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
                }
            }
            double d5 = this.func_226277_ct_() + d3;
            double d1 = this.func_226278_cu_() + d4;
            double d2 = this.func_226281_cx_() + d0;
            float f1 = MathHelper.func_76133_a((double)DraconicArrowEntity.func_213296_b((Vector3d)vector3d));
            this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)d3, (double)d0) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)d4, (double)f1) * 57.2957763671875);
            this.field_70125_A = DraconicArrowEntity.func_234614_e_((float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = DraconicArrowEntity.func_234614_e_((float)this.field_70126_B, (float)this.field_70177_z);
            float f2 = 0.99f;
            float f3 = 0.05f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
                }
                f2 = this.func_203044_p();
            }
            this.func_213317_d(vector3d.func_186678_a((double)f2));
            if (!this.func_189652_ae() && !flag) {
                Vector3d vector3d4 = this.func_213322_ci();
                float antiGrav = ((Float)this.field_70180_af.func_187225_a(GRAV_COMPENSATION)).floatValue();
                if (antiGrav > 0.0f && !this.field_70254_i) {
                    float antiGravActivation = Math.min((float)this.func_213322_ci().func_72433_c() / Math.max(((Float)this.field_70180_af.func_187225_a(INIT_VELOCITY)).floatValue() * 0.75f, 2.0f), 1.0f);
                    this.func_213293_j(vector3d4.field_72450_a, vector3d4.field_72448_b - (double)0.05f * (double)(1.0f - antiGravActivation * antiGrav), vector3d4.field_72449_c);
                } else {
                    this.func_213293_j(vector3d4.field_72450_a, vector3d4.field_72448_b - (double)0.05f, vector3d4.field_72449_c);
                }
            }
            this.func_70107_b(d5, d1, d2);
            this.func_145775_I();
        }
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        PlayerEntity player;
        Entity entity = p_213868_1_.func_216348_a();
        float f = (float)this.func_213322_ci().func_72433_c();
        int i = MathHelper.func_76143_f((double)MathHelper.func_151237_a((double)((double)f * this.func_70242_d()), (double)0.0, (double)2.147483647E9));
        byte penetration = (Byte)this.field_70180_af.func_187225_a(PENETRATION);
        if (this.func_213874_s() > 0 || penetration > 0) {
            if (this.field_213878_az == null) {
                this.field_213878_az = new IntOpenHashSet(5);
            }
            if (this.field_213875_aA == null) {
                this.field_213875_aA = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.field_213878_az.size() >= this.func_213874_s() + 1 && this.field_213878_az.size() >= penetration + 1) {
                this.func_70106_y();
                return;
            }
            this.field_213878_az.add(entity.func_145782_y());
        }
        if (this.func_70241_g()) {
            long j = this.field_70146_Z.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        Entity owner = this.func_234616_v_();
        DamageSource damagesource = this.getDamageSource(entity);
        boolean isEnderman = entity.func_200600_R() == EntityType.field_200803_q;
        int k = entity.func_223314_ad();
        if (this.func_70027_ad() && !isEnderman) {
            entity.func_70015_d(5);
        }
        if (penetration > 1 && entity instanceof PlayerEntity && (player = (PlayerEntity)entity).func_184587_cr() && player.func_184607_cu().func_77973_b() instanceof ShieldItem) {
            player.func_184811_cZ().func_185145_a(player.func_184607_cu().func_77973_b(), 100);
            this.field_70170_p.func_72960_a((Entity)player, (byte)30);
            player.func_184602_cy();
        }
        if (entity.func_70097_a(damagesource, (float)i)) {
            if (isEnderman) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vector3d vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.field_70170_p.field_72995_K && this.func_213874_s() <= 0 && penetration <= 0) {
                    livingentity.func_85034_r(livingentity.func_85035_bI() + 1);
                }
                if (this.field_70256_ap > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.field_70256_ap * 0.6)).func_189985_c() > 0.0) {
                    livingentity.func_70024_g(vector3d.field_72450_a, 0.1, vector3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && owner instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity, (Entity)owner);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)owner), (Entity)livingentity);
                }
                this.func_184548_a(livingentity);
                if (owner != null && livingentity != owner && livingentity instanceof PlayerEntity && owner instanceof ServerPlayerEntity && !this.func_174814_R()) {
                    ((ServerPlayerEntity)owner).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                }
                if (!entity.func_70089_S() && this.field_213875_aA != null) {
                    this.field_213875_aA.add(livingentity);
                }
                if (!this.field_70170_p.field_72995_K && owner instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)owner;
                    if (this.field_213875_aA != null && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_234941_a_(serverplayerentity, (Collection)this.field_213875_aA);
                    } else if (!entity.func_70089_S() && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_234941_a_(serverplayerentity, Arrays.asList(entity));
                    }
                }
            }
            this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.func_213874_s() <= 0 && penetration <= 0) {
                this.func_70106_y();
            }
        } else {
            entity.func_241209_g_(k);
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.0));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    private DamageSource getDamageSource(Entity target) {
        IDraconicDamage damagesource;
        Entity owner = this.func_234616_v_();
        TechLevel techLevel = TechLevel.byIndex((int)((Byte)this.field_70180_af.func_187225_a(TECH_LEVEL)).byteValue());
        if (owner == null) {
            damagesource = DraconicIndirectEntityDamage.arrow(this, (Entity)this, techLevel);
        } else {
            damagesource = DraconicIndirectEntityDamage.arrow(this, owner, techLevel);
            if (owner instanceof LivingEntity) {
                ((LivingEntity)owner).func_130011_c(target);
            }
        }
        if (this.getProjectileImmuneOverride() && DEConfig.projectileAntiImmuneEntities.contains(target.func_200600_R().getRegistryName().toString())) {
            damagesource = new ProjectileAntiImmunityDamage("arrow", (Entity)this, damagesource.func_76346_g(), techLevel);
        }
        return damagesource;
    }

    protected void func_230299_a_(BlockRayTraceResult traceResult) {
        byte basePenetration = (Byte)this.field_70180_af.func_187225_a(PENETRATION);
        int remainingPenetration = basePenetration - this.blockPenetration;
        if (this.field_213878_az != null) {
            remainingPenetration -= this.field_213878_az.size();
        }
        double canPenetrate = (double)remainingPenetration * 0.25;
        byte techLevel = (Byte)this.field_70180_af.func_187225_a(TECH_LEVEL);
        if (canPenetrate > 0.0 && (double)basePenetration >= (double)techLevel * 1.5) {
            VoxelShape voxelshape;
            this.blockPenetration += remainingPenetration;
            BlockPos pos = traceResult.func_216350_a();
            BlockState blockstate = this.field_70170_p.func_180495_p(pos);
            if (!blockstate.isAir((IBlockReader)this.field_70170_p, pos) && !(voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, pos)).func_197766_b()) {
                boolean canPass = true;
                Vector3d vector3d1 = traceResult.func_216347_e().func_178787_e(this.func_213322_ci().func_72432_b().func_216372_d(canPenetrate, canPenetrate, canPenetrate));
                for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                    if (!axisalignedbb.func_186670_a(pos).func_72318_a(vector3d1)) continue;
                    canPass = false;
                    break;
                }
                if (canPass) {
                    this.func_184185_a(SoundEvents.field_232856_w_, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    for (int i = 0; i < 25; ++i) {
                        Vector3d critPos = traceResult.func_216347_e().func_178787_e(this.func_213322_ci().func_72432_b().func_216372_d(2.0, 2.0, 2.0).func_72441_c((-0.5 + this.field_70146_Z.nextGaussian()) * 0.2, (-0.5 + this.field_70146_Z.nextGaussian()) * 0.2, (-0.5 + this.field_70146_Z.nextGaussian()) * 0.2));
                        Vector3d critVel = this.func_213322_ci().func_72432_b().func_216372_d(5.0, 5.0, 5.0);
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, critPos.field_72450_a, critPos.field_72448_b, critPos.field_72449_c, critVel.field_72450_a, critVel.field_72448_b, critVel.field_72449_c);
                    }
                    Vector3d shrapnelTravelEnd = traceResult.func_216347_e().func_178787_e(this.func_213322_ci().func_72432_b().func_216372_d((double)remainingPenetration, (double)remainingPenetration, (double)remainingPenetration));
                    EntityRayTraceResult result = this.func_213866_a(traceResult.func_216347_e(), shrapnelTravelEnd);
                    if (result != null) {
                        Entity entity = result.func_216348_a();
                        DamageSource damagesource = this.getDamageSource(entity);
                        float velocity = (float)this.func_213322_ci().func_72433_c();
                        int damage = MathHelper.func_76143_f((double)MathHelper.func_151237_a((double)((double)velocity * this.func_70242_d()), (double)0.0, (double)2.147483647E9));
                        entity.func_70097_a(damagesource, (float)damage * 0.75f);
                    }
                }
            }
        }
        this.field_195056_av = this.field_70170_p.func_180495_p(traceResult.func_216350_a());
        BlockState blockstate = this.field_70170_p.func_180495_p(traceResult.func_216350_a());
        blockstate.func_215690_a(this.field_70170_p, blockstate, traceResult, (ProjectileEntity)this);
        Vector3d vector3d = traceResult.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(vector3d);
        Vector3d vector3d1 = vector3d.func_72432_b().func_186678_a((double)0.05f);
        this.func_226288_n_(this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b, this.func_226281_cx_() - vector3d1.field_72449_c);
        this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.field_70254_i = true;
        this.field_70249_b = 7;
        this.func_70243_d(false);
        this.func_213872_b((byte)0);
        this.func_213869_a(SoundEvents.field_187731_t);
        this.func_213865_o(false);
        this.func_213870_w();
    }

    public void setEffectsFromItem(ItemStack p_184555_1_) {
        if (p_184555_1_.func_77973_b() == Items.field_185167_i) {
            int i;
            this.potion = PotionUtils.func_185191_c((ItemStack)p_184555_1_);
            List collection = PotionUtils.func_185190_b((ItemStack)p_184555_1_);
            if (!collection.isEmpty()) {
                for (EffectInstance effectinstance : collection) {
                    this.effects.add(new EffectInstance(effectinstance));
                }
            }
            if ((i = DraconicArrowEntity.getCustomColor(p_184555_1_)) == -1) {
                this.updateColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (p_184555_1_.func_77973_b() == Items.field_151032_g) {
            this.potion = Potions.field_185229_a;
            this.effects.clear();
            this.field_70180_af.func_187227_b(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    public static int getCustomColor(ItemStack p_191508_0_) {
        CompoundNBT compoundnbt = p_191508_0_.func_77978_p();
        return compoundnbt != null && compoundnbt.func_150297_b("CustomPotionColor", 99) ? compoundnbt.func_74762_e("CustomPotionColor") : -1;
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == Potions.field_185229_a && this.effects.isEmpty()) {
            this.field_70180_af.func_187227_b(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.field_70180_af.func_187227_b(ID_EFFECT_COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(EffectInstance p_184558_1_) {
        this.effects.add(p_184558_1_);
        this.func_184212_Q().func_187227_b(ID_EFFECT_COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((Potion)this.potion, this.effects)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ID_EFFECT_COLOR, (Object)-1);
        this.field_70180_af.func_187214_a(SPECTRAL_TIME, (Object)0);
        this.field_70180_af.func_187214_a(TECH_LEVEL, (Object)((byte)TechLevel.DRACONIUM.index));
        this.field_70180_af.func_187214_a(PENETRATION, (Object)0);
        this.field_70180_af.func_187214_a(GRAV_COMPENSATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(INIT_VELOCITY, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PROJ_ANTI_IMMUNE, (Object)false);
    }

    private void makeParticle(int p_184556_1_) {
        int i = this.getColor();
        if (i != -1 && p_184556_1_ > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < p_184556_1_; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(ID_EFFECT_COLOR);
    }

    private void setFixedColor(int p_191507_1_) {
        this.fixedColor = true;
        this.field_70180_af.func_187227_b(ID_EFFECT_COLOR, (Object)p_191507_1_);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.potion != Potions.field_185229_a && this.potion != null) {
            compound.func_74778_a("Potion", Registry.field_212621_j.func_177774_c((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            compound.func_74768_a("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (EffectInstance effectinstance : this.effects) {
                listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
            }
            compound.func_218657_a("CustomPotionEffects", (INBT)listnbt);
        }
        if (this.getSpectralTime() > 0) {
            compound.func_74768_a("spectral_time", ((Integer)this.field_70180_af.func_187225_a(SPECTRAL_TIME)).intValue());
        }
        compound.func_74774_a("tech_level", ((Byte)this.field_70180_af.func_187225_a(TECH_LEVEL)).byteValue());
        compound.func_74774_a("penetration", ((Byte)this.field_70180_af.func_187225_a(PENETRATION)).byteValue());
        compound.func_74776_a("grav_comp", ((Float)this.field_70180_af.func_187225_a(GRAV_COMPENSATION)).floatValue());
        compound.func_74776_a("init_velocity", ((Float)this.field_70180_af.func_187225_a(INIT_VELOCITY)).floatValue());
        compound.func_74757_a("proj_anti_immune", ((Boolean)this.field_70180_af.func_187225_a(PROJ_ANTI_IMMUNE)).booleanValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Potion", 8)) {
            this.potion = PotionUtils.func_185187_c((CompoundNBT)compound);
        }
        for (EffectInstance effectinstance : PotionUtils.func_185192_b((CompoundNBT)compound)) {
            this.addEffect(effectinstance);
        }
        if (compound.func_150297_b("Color", 99)) {
            this.setFixedColor(compound.func_74762_e("Color"));
        } else {
            this.updateColor();
        }
        if (compound.func_74764_b("spectral_time")) {
            this.setSpectral(compound.func_74762_e("spectral_time"));
        }
        if (compound.func_74764_b("tech_level")) {
            this.field_70180_af.func_187227_b(TECH_LEVEL, (Object)compound.func_74771_c("tech_level"));
        }
        if (compound.func_74764_b("penetration")) {
            this.field_70180_af.func_187227_b(PENETRATION, (Object)compound.func_74771_c("penetration"));
        }
        if (compound.func_74764_b("grav_comp")) {
            this.field_70180_af.func_187227_b(GRAV_COMPENSATION, (Object)Float.valueOf(compound.func_74760_g("grav_comp")));
        }
        if (compound.func_74764_b("init_velocity")) {
            this.field_70180_af.func_187227_b(INIT_VELOCITY, (Object)Float.valueOf(compound.func_74760_g("init_velocity")));
        }
        if (compound.func_74764_b("proj_anti_immune")) {
            this.field_70180_af.func_187227_b(PROJ_ANTI_IMMUNE, (Object)compound.func_74767_n("proj_anti_immune"));
        }
    }

    protected void func_184548_a(LivingEntity p_184548_1_) {
        int spectralTime;
        super.func_184548_a(p_184548_1_);
        for (EffectInstance effectinstance : this.potion.func_185170_a()) {
            p_184548_1_.func_195064_c(new EffectInstance(effectinstance.func_188419_a(), Math.max(effectinstance.func_76459_b() / 8, 1), effectinstance.func_76458_c(), effectinstance.func_82720_e(), effectinstance.func_188418_e()));
        }
        if (!this.effects.isEmpty()) {
            for (EffectInstance effectinstance1 : this.effects) {
                p_184548_1_.func_195064_c(effectinstance1);
            }
        }
        if ((spectralTime = ((Integer)this.field_70180_af.func_187225_a(SPECTRAL_TIME)).intValue()) > 0) {
            EffectInstance effectinstance;
            effectinstance = new EffectInstance(Effects.field_188423_x, spectralTime, 0);
            p_184548_1_.func_195064_c(effectinstance);
        }
    }

    protected ItemStack func_184550_j() {
        if (this.effects.isEmpty() && this.potion == Potions.field_185229_a) {
            return new ItemStack((IItemProvider)Items.field_151032_g);
        }
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_185167_i);
        PotionUtils.func_185188_a((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.func_185184_a((ItemStack)itemstack, this.effects);
        if (this.fixedColor) {
            itemstack.func_196082_o().func_74768_a("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), d0, d1, d2);
                }
            }
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public IPacket<?> func_213297_N() {
        return BCoreNetwork.getEntitySpawnPacket((Entity)this);
    }

    public boolean func_180431_b(DamageSource source) {
        return source.func_76347_k() || super.func_180431_b(source);
    }
}

