/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import codechicken.lib.data.MCDataOutput;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.IPhase;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public abstract class Phase
implements IPhase {
    protected final DraconicGuardianEntity guardian;
    protected Random random = new Random();

    public Phase(DraconicGuardianEntity guardian) {
        this.guardian = guardian;
    }

    @Override
    public boolean getIsStationary() {
        return false;
    }

    @Override
    public void clientTick() {
    }

    @Override
    public void serverTick() {
    }

    @Override
    public void globalServerTick() {
    }

    @Override
    public void onCrystalAttacked(GuardianCrystalEntity crystal, BlockPos pos, DamageSource dmgSrc, @Nullable PlayerEntity plyr, float damage, boolean destroyed) {
    }

    @Override
    public void initPhase() {
    }

    @Override
    public void removeAreaEffect() {
    }

    @Override
    public float getMaxRiseOrFall() {
        return 0.6f;
    }

    @Override
    @Nullable
    public Vector3d getTargetLocation() {
        return null;
    }

    @Override
    public float onAttacked(DamageSource source, float damage, float shield, boolean effective) {
        return damage;
    }

    @Override
    public float getYawFactor() {
        float f = MathHelper.func_76133_a((double)Entity.func_213296_b((Vector3d)this.guardian.func_213322_ci())) + 1.0f;
        float f1 = Math.min(f, 40.0f);
        return 0.7f / f1 / f;
    }

    protected void debug(String message) {
        DraconicEvolution.LOGGER.debug(message);
    }

    public boolean isEnded() {
        return this.guardian.getPhaseManager().getCurrentPhase() != this || !this.guardian.func_70089_S();
    }

    @Override
    public void sendPacket(Consumer<MCDataOutput> callBack, int data) {
        DraconicNetwork.sendGuardianPhasePacket(this.guardian, this, data, callBack);
    }

    public boolean isValidTarget(LivingEntity entity) {
        return entity.func_70089_S() && entity.field_70170_p.func_230315_m_() == this.guardian.field_70170_p.func_230315_m_() && entity.func_70068_e((Entity)this.guardian) < 90000.0;
    }
}

