/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.draconicevolution.blocks.PlacedItem;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePlacedItem;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;

public class RenderTilePlacedItem
extends TileEntityRenderer<TilePlacedItem> {
    public RenderTilePlacedItem(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TilePlacedItem tile, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        Minecraft mc = Minecraft.func_71410_x();
        List<ItemStack> stackList = tile.getStacksInOrder();
        float scale = stackList.size() == 1 && tile.toolMode.get() ? 0.875f : 0.4375f;
        mStack.func_227860_a_();
        mStack.func_227861_a_(0.5, 0.5, 0.5);
        Direction direction = (Direction)tile.func_195044_w().func_177229_b((Property)PlacedItem.FACING);
        this.rotateToSide(direction, mStack);
        for (int i = 0; i < stackList.size(); ++i) {
            ItemStack stack = stackList.get(i);
            mStack.func_227860_a_();
            if (stack.func_77973_b() instanceof BlockItem) {
                mStack.func_227861_a_(PlacedItem.getXOffset(i, stackList.size()), -0.3125, PlacedItem.getZOffset(i, stackList.size()));
                mStack.func_227863_a_(new Quaternion(0.0f, (float)tile.rotation[i].get() * -22.5f, 0.0f, true));
                mStack.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
                mStack.func_227862_a_(0.75f, 0.75f, 0.75f);
            } else {
                mStack.func_227861_a_(PlacedItem.getXOffset(i, stackList.size()), -0.5 + 0.034375 * (double)scale, PlacedItem.getZOffset(i, stackList.size()));
                mStack.func_227863_a_(new Quaternion(0.0f, (float)tile.rotation[i].get() * -22.5f, 0.0f, true));
                mStack.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
                mStack.func_227862_a_(scale, scale, scale);
            }
            mc.func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, packedLight, packedOverlay, mStack, getter);
            mStack.func_227865_b_();
            mStack.func_227861_a_(0.0, (double)5.0E-5f, 0.0);
        }
        mStack.func_227865_b_();
    }

    private void rotateToSide(Direction direction, MatrixStack mStack) {
        switch (direction) {
            case DOWN: {
                mStack.func_227863_a_(new Quaternion(180.0f, 0.0f, 0.0f, true));
                break;
            }
            case NORTH: {
                mStack.func_227863_a_(new Quaternion(-90.0f, 0.0f, 0.0f, true));
                break;
            }
            case SOUTH: {
                mStack.func_227863_a_(new Quaternion(-90.0f, 0.0f, 180.0f, true));
                break;
            }
            case WEST: {
                mStack.func_227863_a_(new Quaternion(-90.0f, 0.0f, 90.0f, true));
                break;
            }
            case EAST: {
                mStack.func_227863_a_(new Quaternion(-90.0f, 0.0f, -90.0f, true));
            }
        }
    }
}

