/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.lighting.LightModel;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import com.brandon3055.draconicevolution.blocks.machines.Generator;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGenerator;
import com.brandon3055.draconicevolution.client.DETextures;
import com.brandon3055.draconicevolution.utils.ResourceHelperDE;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderTileGenerator
extends TileEntityRenderer<TileGenerator> {
    private static RenderType modelType = RenderType.func_228639_c_();
    private final CCModel fanModel;

    public RenderTileGenerator(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        Map map = OBJParser.parseModels((ResourceLocation)ResourceHelperDE.getResource("models/block/generator/generator_fan.obj"), (int)7, null);
        this.fanModel = CCModel.combine(map.values()).backfacedCopy();
    }

    public void render(TileGenerator tile, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        IconTransformation icon = new IconTransformation(DETextures.GENERATOR);
        if (icon.icon == null) {
            return;
        }
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ccrs.bind(modelType, getter);
        mat.translate(Vector3.CENTER);
        mat.apply((Transformation)new Rotation((double)((Direction)tile.func_195044_w().func_177229_b((Property)Generator.FACING)).func_176734_d().func_185119_l() * -0.017453292519943, 0.0, 1.0, 0.0));
        mat.apply((Transformation)new Scale(0.0625));
        mat.apply(new Rotation((double)(tile.rotation + tile.rotationSpeed * partialTicks), 1.0, 0.0, 0.0).at(new Vector3(0.0, -1.5, -4.5)));
        this.fanModel.render(ccrs, new IVertexOperation[]{LightModel.standardLightModel, icon, mat});
    }
}

