/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.blocks.DraconiumChest;
import com.brandon3055.draconicevolution.blocks.tileentity.chest.TileDraconiumChest;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class DraconiumChestTileRenderer
extends TileEntityRenderer<TileDraconiumChest> {
    private static final RenderType renderType = RenderType.func_228638_b_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/draconium_chest.png"));
    private final ModelRenderer lid;
    private final ModelRenderer bottom = new ModelRenderer(64, 64, 0, 19);
    private final ModelRenderer lock;

    public DraconiumChestTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        this.bottom.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.lid = new ModelRenderer(64, 64, 0, 0);
        this.lid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.lid.field_78797_d = 9.0f;
        this.lid.field_78798_e = 1.0f;
        this.lock = new ModelRenderer(64, 64, 0, 0);
        this.lock.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.lock.field_78797_d = 8.0f;
    }

    public void render(TileDraconiumChest tile, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        BlockState blockstate = tile.func_195044_w();
        float rotation = ((Direction)blockstate.func_177229_b((Property)DraconiumChest.FACING)).func_185119_l();
        float lidAngle = MathHelper.interpolate((float)tile.prevLidAngle, (float)tile.lidAngle, (float)partialTicks);
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        this.renderChest(mStack, getter, rotation, lidAngle *= -1.5707965f, packedLight, packedOverlay, tile.colour.get());
    }

    public void renderChest(MatrixStack mStack, IRenderTypeBuffer getter, float rotation, float lidAngle, int packedLight, int packedOverlay, int colour) {
        mStack.func_227860_a_();
        mStack.func_227861_a_(0.5, 0.5, 0.5);
        mStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-rotation));
        mStack.func_227861_a_(-0.5, -0.5, -0.5);
        IVertexBuilder buffer = getter.getBuffer(renderType);
        this.render(mStack, buffer, this.lid, this.lock, this.bottom, lidAngle, packedLight, packedOverlay, colour);
        mStack.func_227865_b_();
    }

    private void render(MatrixStack mStack, IVertexBuilder buffer, ModelRenderer lidRenderer, ModelRenderer lockRenderer, ModelRenderer bottomRenderer, float lidAngle, int packedLight, int packedOverlay, int colour) {
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        lockRenderer.field_78795_f = lidRenderer.field_78795_f = lidAngle;
        lidRenderer.func_228309_a_(mStack, buffer, packedLight, packedOverlay, red, green, blue, 1.0f);
        lockRenderer.func_228309_a_(mStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        bottomRenderer.func_228309_a_(mStack, buffer, packedLight, packedOverlay, red, green, blue, 1.0f);
    }
}

