/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.modelfx;

import codechicken.lib.math.MathHelper;
import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.draconicevolution.client.render.modelfx.ModelEffect;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;

public class StaffModelEffect
extends ModelEffect {
    private RenderType renderType = RenderType.func_228632_a_((String)"modelEffectType", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/particle/white_orb.png"), false, false)).func_228726_a_(RenderState.field_228512_d_).func_228713_a_(RenderState.field_228516_h_).func_228714_a_(RenderState.field_228491_A_).func_228727_a_(RenderState.field_228496_F_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    private RenderType renderSolidType = RenderType.func_228632_a_((String)"modelEffectType4", (VertexFormat)DefaultVertexFormats.field_227850_m_, (int)6, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228714_a_(RenderState.field_228491_A_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    private int lastProfile = 0;

    @Override
    public RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    protected void doRender(IVertexBuilder builder, float partialTicks, TechLevel techLevel) {
        boolean idle = false;
        float time = (float)TimeKeeper.getClientTick() + partialTicks;
        double charge = 0.5 + Math.sin(time / 10.0f) / 2.0;
        int pCount = 4;
        Color color = techLevel == TechLevel.CHAOTIC ? new Color(16720387) : new Color(16729091);
        this.drawFeedInParticles(builder, 16, time, 1.0f, idle, color);
    }

    private void drawCrystalParticles(IVertexBuilder builder, int pCount, float time, float scaleMod, boolean idle) {
        StaffModelEffect.setRandSeed((int)time / 30);
        double gemHeight = 0.4;
        int sCount = 6;
        for (int ci = 0; ci < pCount; ++ci) {
            float lifeTime = idle ? 15.0f + StaffModelEffect.nextFloat() * 15.0f : 15.0f;
            float age = (time + StaffModelEffect.nextFloat() * lifeTime) % lifeTime / lifeTime;
            float arcPos = (age - 0.5f) * 2.0f;
            double angle = Math.PI * 2 / (double)sCount * (double)(ci % sCount);
            double cosArc = Math.cos((double)arcPos * 1.5707963267948966);
            double scaleCurve = Math.max(cosArc, idle ? 0.0 : Math.tanh(((double)arcPos - 0.5) * 1.5707963267948966));
            double scale = (0.015625 + (double)StaffModelEffect.nextFloat() * 0.03125) * scaleCurve * (double)scaleMod;
            double diameter = 0.0625 * cosArc;
            double x = Math.sin(angle += (double)(age * 5.0f)) * diameter;
            double z = Math.cos(angle) * diameter;
            double y = (double)age * gemHeight - gemHeight / 2.0;
            float flicker = StaffModelEffect.noise(time / lifeTime * 5.0f);
            Color color = new Color(16720387);
            float r = color.getRed();
            float g = color.getGreen();
            float b = color.getBlue();
            this.drawParticle(builder, x, y, z, scale, r / 255.0f, g / 255.0f, b / 255.0f, 1.0f);
        }
    }

    private void drawFeedInParticles(IVertexBuilder builder, int pCount, float time, float scaleMod, boolean idle, Color color) {
        double gemHeight = 0.0;
        double minY = -0.15625;
        double maxY = 0.34375;
        for (int ci = 0; ci < pCount; ++ci) {
            StaffModelEffect.setRandSeed(ci * 8);
            float lifeTime = 10.0f + StaffModelEffect.nextFloat() * 15.0f;
            float offsetTime = time + StaffModelEffect.nextFloat() * lifeTime;
            float age = offsetTime % lifeTime / lifeTime;
            age *= age;
            StaffModelEffect.setRandSeed((int)(offsetTime / lifeTime) + (int)(StaffModelEffect.nextFloat() * 128.0f));
            double pos = -0.25 + (double)StaffModelEffect.nextFloat() * 1.25;
            double y = minY + pos * (maxY - minY);
            double z = 0.125f * (float)((double)StaffModelEffect.nextFloat() > 0.5 ? -1 : 1);
            if (pos < 0.0) {
                z *= 1.0 - pos / -0.25;
            }
            float scale = idle ? 0.0078125f + (0.5f - Math.abs(age - 0.5f)) * 0.03125f : 0.0078125f + age * 0.03125f;
            z *= 1.0 - (double)age;
            double targetY = (double)age * gemHeight - gemHeight / 2.0;
            y = MathHelper.interpolate((double)y, (double)targetY, (double)age);
            float r = color.getRed();
            float g = color.getGreen();
            float b = color.getBlue();
            this.drawParticle(builder, 0.0, y, z, scale, r / 255.0f, g / 255.0f, b / 255.0f, 1.0f);
        }
    }
}

