/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.render.buffer.VBORenderType;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.brandon3055.draconicevolution.client.render.modelfx.StaffModelEffect;
import com.brandon3055.draconicevolution.items.equipment.ModularStaff;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.SimpleModelTransform;

public class RenderModularStaff
extends ToolRenderBase {
    private static SimpleModelTransform TRANSFORMATION;
    private CCModel baseGui;
    private CCModel materialGui;
    private CCModel traceGui;
    private CCModel bladeGui;
    private CCModel gemGui;
    private VBORenderType guiBaseVBOType;
    private VBORenderType guiMaterialVBOType;
    private VBORenderType guiMaterialChaosVBOType;
    private VBORenderType guiTraceVBOType;
    private VBORenderType guiBladeVBOType;
    private VBORenderType guiGemVBOType;
    @Nullable
    protected LivingEntity entity;
    @Nullable
    protected ClientWorld world;
    private StaffModelEffect effectRenderer = new StaffModelEffect();
    private final ItemOverrideList overrideList = new ItemOverrideList(){

        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            RenderModularStaff.this.entity = entity;
            RenderModularStaff.this.world = world == null ? (entity == null ? null : (ClientWorld)entity.field_70170_p) : null;
            return originalModel;
        }
    };

    @Override
    public IModelTransform getModelTransform() {
        return TRANSFORMATION;
    }

    public RenderModularStaff(TechLevel techLevel) {
        super(techLevel, "staff");
        Map model = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/item/equipment/staff.obj"), (int)4, null);
        this.baseModel = CCModel.combine(Arrays.asList((CCModel)model.get("handle"), (CCModel)model.get("head_connection"), (CCModel)model.get("cage_connection"))).backfacedCopy();
        this.materialModel = CCModel.combine(Arrays.asList((CCModel)model.get("head"), (CCModel)model.get("crystal_cage"))).backfacedCopy();
        this.traceModel = (CCModel)model.get("trace");
        this.bladeModel = ((CCModel)model.get("blade")).backfacedCopy();
        this.gemModel = CCModel.combine(Arrays.asList((CCModel)model.get("focus_gem"), (CCModel)model.get("energy_crystal"))).backfacedCopy();
        this.initBaseVBO();
        this.initMaterialVBO();
        this.initTraceVBO();
        this.initBladeVBO();
        this.initGemVBO();
        model = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/item/equipment/staff_gui.obj"), (int)4, null);
        this.baseGui = CCModel.combine(Arrays.asList((CCModel)model.get("handle"), (CCModel)model.get("head_connection"))).backfacedCopy();
        this.materialGui = ((CCModel)model.get("head")).backfacedCopy();
        this.traceGui = (CCModel)model.get("trace");
        this.bladeGui = ((CCModel)model.get("blade")).backfacedCopy();
        this.gemGui = ((CCModel)model.get("focus_gem")).backfacedCopy();
        this.guiBaseVBOType = new VBORenderType(this.modelType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.baseGui.render(ccrs, new IVertexOperation[0]);
        });
        this.guiMaterialVBOType = new VBORenderType(this.modelGuiType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.materialGui.render(ccrs, new IVertexOperation[0]);
        });
        this.guiMaterialChaosVBOType = new VBORenderType(this.chaosType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.materialGui.render(ccrs, new IVertexOperation[0]);
        });
        this.guiTraceVBOType = new VBORenderType(this.shaderParentType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.traceGui.render(ccrs, new IVertexOperation[0]);
        });
        this.guiBladeVBOType = new VBORenderType(this.shaderParentType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.bladeGui.render(ccrs, new IVertexOperation[0]);
        });
        this.guiGemVBOType = new VBORenderType(this.shaderParentType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.gemGui.render(ccrs, new IVertexOperation[0]);
        });
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    @Override
    public void renderTool(CCRenderState ccrs, ItemStack stack, ItemCameraTransforms.TransformType transform, Matrix4 mat, MatrixStack mStack, IRenderTypeBuffer getter, boolean gui, int packedLight) {
        float flair = 0.0f;
        if (this.entity != null && this.entity.func_184614_ca() == stack) {
            flair = MathHelper.interpolate((float)this.entity.field_70732_aI, (float)this.entity.field_70733_aJ, (float)Minecraft.func_71410_x().func_184121_ak());
            flair = MathHelper.clip((float)(flair * 5.0f), (float)0.0f, (float)1.0f);
        }
        this.handleArmPose(stack, transform, mat);
        if (gui) {
            this.transform(mat, 0.19, 0.19, 0.5, 1.1);
            getter.getBuffer((RenderType)this.guiBaseVBOType.withMatrix(mat).withLightMap(packedLight));
            if (this.techLevel == TechLevel.CHAOTIC && DEConfig.toolShaders) {
                getter.getBuffer((RenderType)this.guiMaterialChaosVBOType.withMatrix(mat).withLightMap(packedLight).withState((RenderState)RenderModularStaff.getShaderType(this.chaosType, chaosShader)));
            } else {
                getter.getBuffer((RenderType)this.guiMaterialVBOType.withMatrix(mat).withLightMap(packedLight));
            }
            if (DEConfig.toolShaders) {
                getter.getBuffer((RenderType)this.guiTraceVBOType.withMatrix(mat).withLightMap(packedLight).withState((RenderState)RenderModularStaff.getShaderType(this.shaderParentType, this.techLevel, traceShader, flair)));
                getter.getBuffer((RenderType)this.guiBladeVBOType.withMatrix(mat).withLightMap(packedLight).withState((RenderState)RenderModularStaff.getShaderType(this.shaderParentType, this.techLevel, bladeShader, flair)));
                getter.getBuffer((RenderType)this.guiGemVBOType.withMatrix(mat).withLightMap(packedLight).withState((RenderState)RenderModularStaff.getShaderType(this.shaderParentType, this.techLevel, gemShader, flair)));
            } else {
                getter.getBuffer((RenderType)this.guiTraceVBOType.withMatrix(mat).withLightMap(packedLight));
                getter.getBuffer((RenderType)this.guiBladeVBOType.withMatrix(mat).withLightMap(packedLight));
                getter.getBuffer((RenderType)this.guiGemVBOType.withMatrix(mat).withLightMap(packedLight));
            }
            return;
        }
        if (transform == ItemCameraTransforms.TransformType.FIXED || transform == ItemCameraTransforms.TransformType.GROUND || transform == ItemCameraTransforms.TransformType.NONE) {
            this.transform(mat, 0.6, 0.6, 0.5, 0.75);
        } else {
            this.transform(mat, 0.27, 0.27, 0.5, 1.125);
            if (transform == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transform == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
                mat.rotate(-0.7853981633974351, Vector3.Z_NEG);
            } else {
                mat.rotate(0.7853981633974351, Vector3.Z_NEG);
            }
        }
        getter.getBuffer((RenderType)this.baseVBOType.withMatrix(mat).withLightMap(packedLight));
        if (this.techLevel == TechLevel.CHAOTIC && DEConfig.toolShaders) {
            getter.getBuffer((RenderType)this.materialChaosVBOType.withMatrix(mat).withLightMap(packedLight).withState((RenderState)RenderModularStaff.getShaderType(this.chaosType, chaosShader)));
        } else {
            getter.getBuffer((RenderType)this.materialVBOType.withMatrix(mat).withLightMap(packedLight));
        }
        if (DEConfig.toolShaders) {
            getter.getBuffer((RenderType)this.traceVBOType.withMatrix(mat).withLightMap(packedLight).withState((RenderState)RenderModularStaff.getShaderType(this.shaderParentType, this.techLevel, traceShader, flair)));
            getter.getBuffer((RenderType)this.bladeVBOType.withMatrix(mat).withLightMap(packedLight).withState((RenderState)RenderModularStaff.getShaderType(this.shaderParentType, this.techLevel, bladeShader, flair)));
            getter.getBuffer((RenderType)this.gemVBOType.withMatrix(mat).withLightMap(packedLight).withState((RenderState)RenderModularStaff.getShaderType(this.shaderParentType, this.techLevel, gemShader, flair)));
        } else {
            getter.getBuffer((RenderType)this.traceVBOType.withMatrix(mat).withLightMap(packedLight));
            getter.getBuffer((RenderType)this.bladeVBOType.withMatrix(mat).withLightMap(packedLight));
            getter.getBuffer((RenderType)this.gemVBOType.withMatrix(mat).withLightMap(packedLight));
        }
        ToolRenderBase.endBatch(getter);
        Minecraft mc = Minecraft.func_71410_x();
        mat.rotate((double)RenderModularStaff.torad(90.0), Vector3.X_NEG);
        mat.translate(-0.5, 0.1, -0.5);
        this.effectRenderer.renderEffect(mat, getter, mc.func_184121_ak(), this.techLevel);
    }

    private void testParticleRender(CCRenderState ccrs, ItemStack stack, ItemCameraTransforms.TransformType transform, Matrix4 mat, MatrixStack mStack, IRenderTypeBuffer getter, boolean gui) {
        Minecraft mc = Minecraft.func_71410_x();
        float partialTicks = mc.func_184121_ak();
        ActiveRenderInfo renderInfo = mc.func_175598_ae().field_217783_c;
        RenderSystem.pushMatrix();
        RenderSystem.disableCull();
        mStack.func_227861_a_(0.0, 1.0, 1.0);
        Vector3 vec = new Vector3(0.0, 0.0, -1.0);
        mat.applyN(vec);
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(GuiHelperOld.TRANS_TYPE), (Transformation)mat);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float width = 1.0f;
        float height = 1.0f;
        builder.func_225582_a_((double)x, (double)(y + height), (double)z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)(y + height), (double)z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)y, (double)z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_225582_a_((double)x, (double)y, (double)z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        ToolRenderBase.endBatch(getter);
        RenderSystem.popMatrix();
    }

    private void handleArmPose(ItemStack stack, ItemCameraTransforms.TransformType transform, Matrix4 mat) {
        if (this.isThirdPerson(transform)) {
            if (transform == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                mat.rotate((double)RenderModularStaff.torad(-15.0), new Vector3(-0.5, 0.5, 0.0));
            } else {
                mat.rotate((double)RenderModularStaff.torad(15.0), new Vector3(-0.5, 0.5, 0.0));
            }
            if (this.entity != null) {
                double anim = this.entity.field_70733_aJ;
                mat.translate(0.125 * anim, 0.125 * anim, 0.0);
                mat.rotate((double)RenderModularStaff.torad(-20.0) * anim, Vector3.Z_POS);
            }
        }
    }

    private boolean isThirdPerson(ItemCameraTransforms.TransformType transform) {
        return transform == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || transform == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
    }

    public static void doMixinStuff(LivingEntity entity, PlayerModel<?> model) {
        ItemStack mainHand = entity.func_184614_ca();
        ItemStack offHand = entity.func_184592_cb();
        boolean rightHanded = entity.func_184591_cq() == HandSide.RIGHT;
        boolean hasMain = mainHand.func_77973_b() instanceof ModularStaff;
        boolean hasOff = offHand.func_77973_b() instanceof ModularStaff;
        if (hasMain) {
            if (hasMain) {
                RenderModularStaff.setStaffPose(entity, model.field_178723_h, model.field_178724_i, model.field_78115_e, model.field_78116_c, !rightHanded, !hasOff);
            }
            model.field_178733_c.func_217177_a(model.field_178722_k);
            model.field_178731_d.func_217177_a(model.field_178721_j);
            model.field_178734_a.func_217177_a(model.field_178724_i);
            model.field_178732_b.func_217177_a(model.field_178723_h);
            model.field_178730_v.func_217177_a(model.field_78115_e);
        }
    }

    public static void setStaffPose(LivingEntity entity, ModelRenderer rightArm, ModelRenderer leftArm, ModelRenderer body, ModelRenderer head, boolean lefthand, boolean bothHands) {
        if (lefthand) {
            leftArm.field_78796_g = head.field_78796_g + RenderModularStaff.torad(15.0);
            leftArm.field_78795_f = head.field_78795_f - RenderModularStaff.torad(60.0) - RenderModularStaff.torad(20.0f * entity.field_70733_aJ);
            if (bothHands) {
                rightArm.field_78795_f = head.field_78795_f - RenderModularStaff.torad(60.0) - RenderModularStaff.torad(20.0f * entity.field_70733_aJ);
                rightArm.field_78796_g = head.field_78796_g - RenderModularStaff.torad(45.0);
            }
        } else {
            rightArm.field_78796_g = head.field_78796_g - RenderModularStaff.torad(15.0);
            rightArm.field_78795_f = head.field_78795_f - RenderModularStaff.torad(60.0) - RenderModularStaff.torad(20.0f * entity.field_70733_aJ);
            if (bothHands) {
                leftArm.field_78795_f = head.field_78795_f - RenderModularStaff.torad(60.0) - RenderModularStaff.torad(20.0f * entity.field_70733_aJ);
                leftArm.field_78796_g = head.field_78796_g + RenderModularStaff.torad(45.0);
            }
        }
    }

    public static float torad(double degrees) {
        return (float)(degrees * 0.017453292519943);
    }

    static {
        HashMap<ItemCameraTransforms.TransformType, TransformationMatrix> map = new HashMap<ItemCameraTransforms.TransformType, TransformationMatrix>();
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f));
        map.put(ItemCameraTransforms.TransformType.FIXED, TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)180.0f, (float)0.0f, (float)1.0f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TransformUtils.create((float)0.0f, (float)1.5f, (float)-6.5f, (float)0.0f, (float)90.0f, (float)-15.0f, (float)0.85f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.create((float)0.0f, (float)1.5f, (float)-6.5f, (float)0.0f, (float)-90.0f, (float)15.0f, (float)0.85f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create((float)1.13f, (float)3.2f, (float)1.13f, (float)0.0f, (float)90.0f, (float)-45.0f, (float)0.68f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create((float)1.13f, (float)3.2f, (float)1.13f, (float)0.0f, (float)-90.0f, (float)45.0f, (float)0.68f));
        TRANSFORMATION = new SimpleModelTransform(ImmutableMap.copyOf(map));
    }
}

