/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.utils.ResourceHelperDE;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class ReactorBeamFX
extends Particle {
    protected int ticksTillDeath = 0;
    protected float fxState;
    private float powerState;
    private TileReactorCore tile;
    private boolean isInjectorEffect;
    private Direction facing;
    private float dist;
    private static Colour fieldBeamColour = new ColourARGB(45311);
    private static Colour extractBeamColour = new ColourARGB(0xFF6600);
    private static Colour energyBeamColour = new ColourARGB(0xFF0000);
    private int boltSeed = -1;
    private int ttl = 10;
    public static final RenderType fallBackType = RenderType.func_228632_a_((String)"fall_back_type", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/particle/reactor_energy_beam.png"), false, false)).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    public static ShaderProgram beamShaderI = ShaderProgramBuilder.builder().addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/reactor_beam_i.frag")).uniform("time", UniformType.FLOAT).uniform("fade", UniformType.FLOAT).uniform("power", UniformType.FLOAT).uniform("startup", UniformType.FLOAT)).build();
    public static ShaderProgram beamShaderO = ShaderProgramBuilder.builder().addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/reactor_beam_o.frag")).uniform("time", UniformType.FLOAT).uniform("fade", UniformType.FLOAT).uniform("power", UniformType.FLOAT).uniform("startup", UniformType.FLOAT)).build();
    public static ShaderProgram beamShaderE = ShaderProgramBuilder.builder().addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/reactor_beam_e.frag")).uniform("time", UniformType.FLOAT).uniform("fade", UniformType.FLOAT).uniform("power", UniformType.FLOAT).uniform("startup", UniformType.FLOAT)).build();
    private static final IParticleRenderType FX_HANDLER = new FXHandler("textures/particle/reactor_energy_beam.png");

    public ReactorBeamFX(ClientWorld worldIn, Vec3D pos, Direction facing, TileReactorCore tile, boolean isInjectorEffect) {
        super(worldIn, pos.x, pos.y, pos.z);
        this.tile = tile;
        this.facing = facing;
        this.isInjectorEffect = isInjectorEffect;
        this.dist = (float)Utils.getDistanceAtoB((Vec3D)pos, (Vec3D)Vec3D.getCenter((BlockPos)tile.func_174877_v()));
        this.field_187136_p.setSeed(worldIn.field_73012_v.nextLong());
        this.func_187108_a(new AxisAlignedBB(this.field_187126_f, this.field_187127_g, this.field_187128_h, (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p()));
    }

    public void updateFX(float fxState, float powerState) {
        this.fxState = fxState;
        if (powerState != this.powerState) {
            ReactorBeamFX.fieldBeamColour.r = (byte)(this.powerState * 255.0f);
            ReactorBeamFX.fieldBeamColour.g = (byte)((1.0f - this.powerState) * 176.0f);
            ReactorBeamFX.fieldBeamColour.b = (byte)((1.0f - this.powerState) * 255.0f);
        }
        this.powerState = powerState;
        this.ticksTillDeath = 4;
        if (this.ttl-- <= 0) {
            this.func_187112_i();
        }
    }

    public void func_189213_a() {
        if (this.ticksTillDeath-- <= 0) {
            this.func_187112_i();
        }
        this.ttl = 10;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        if (this.tile.roller != null || !(buffer instanceof BufferBuilder)) {
            return;
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind(buffer, DefaultVertexFormats.field_227851_o_);
        ccrs.brightness = 240;
        Vector3d viewVec = renderInfo.func_216785_c();
        Vec3D pos1 = new Vec3D(this.field_187126_f - viewVec.field_72450_a, this.field_187127_g - viewVec.field_72448_b, this.field_187128_h - viewVec.field_72449_c).offset(this.facing, -0.35);
        float texOffset = ((float)ClientEventHandler.elapsedTicks + partialTicks) / -150.0f;
        float coreSize = (float)this.tile.getCoreDiameter() / 2.3f;
        if (!DEConfig.reactorShaders) {
            this.renderWithoutShaders(ccrs, buffer, pos1, coreSize, texOffset);
            return;
        }
        float animation = ((float)ClientEventHandler.elapsedTicks + partialTicks) * 0.02f;
        if (this.isInjectorEffect) {
            UniformCache uniforms = beamShaderE.pushCache();
            uniforms.glUniform1f("time", animation);
            uniforms.glUniform1f("fade", 1.0f);
            uniforms.glUniform1f("power", this.fxState);
            uniforms.glUniform1f("startup", this.fxState);
            beamShaderE.use();
            beamShaderE.popCache(uniforms);
            Vec3D pos2 = pos1.copy().offset(this.facing, 0.6);
            this.renderShaderBeam(ccrs, buffer, pos1, 0.1f, 0.1f, 0.6f, true, false);
            ccrs.draw();
            uniforms.glUniform1f("fade", 0.0f);
            beamShaderE.popCache(uniforms);
            this.renderShaderBeam(ccrs, buffer, pos2, 0.1f, (double)coreSize / 1.5, this.dist - coreSize * 1.3f, false, false);
            ccrs.draw();
            beamShaderE.release();
        } else {
            Vec3D pos2 = pos1.copy().offset(this.facing, 0.8);
            UniformCache uniforms = beamShaderO.pushCache();
            uniforms.glUniform1f("time", animation);
            uniforms.glUniform1f("fade", 1.0f);
            uniforms.glUniform1f("power", (float)this.tile.animExtractState.get());
            uniforms.glUniform1f("startup", (float)this.tile.animExtractState.get());
            beamShaderO.use();
            beamShaderO.popCache(uniforms);
            this.renderShaderBeam(ccrs, buffer, pos1, 0.263f, 0.263f, 0.8f, true, false);
            ccrs.draw();
            uniforms.glUniform1f("fade", 0.0f);
            beamShaderO.popCache(uniforms);
            this.renderShaderBeam(ccrs, buffer, pos2, 0.263f, coreSize / 2.0f, this.dist - coreSize * 1.3f, false, false);
            ccrs.draw();
            beamShaderO.release();
            uniforms = beamShaderI.pushCache();
            uniforms.glUniform1f("time", animation);
            uniforms.glUniform1f("fade", 1.0f);
            uniforms.glUniform1f("power", this.fxState);
            uniforms.glUniform1f("startup", this.fxState);
            beamShaderI.use();
            beamShaderI.popCache(uniforms);
            this.renderShaderBeam(ccrs, buffer, pos1, 0.355f, 0.355f, 0.8f, true, false);
            ccrs.draw();
            uniforms.glUniform1f("fade", 0.0f);
            beamShaderI.popCache(uniforms);
            this.renderShaderBeam(ccrs, buffer, pos2, 0.355f, coreSize, this.dist - coreSize, false, true);
            ccrs.draw();
            beamShaderI.release();
        }
    }

    public void renderBeam(CCRenderState ccrs, IVertexBuilder buffer, Vec3D pos, float widthStart, float widthEnd, float length, float beamAnimation, float beamRotation, boolean fadeReverse, Colour colour) {
        ccrs.startDrawing(5, DefaultVertexFormats.field_227851_o_);
        float sides = 99.0f;
        float r = (float)(colour.r & 0xFF) / 255.0f;
        float g = (float)(colour.g & 0xFF) / 255.0f;
        float b = (float)(colour.b & 0xFF) / 255.0f;
        int i = 0;
        while ((float)i < sides + 1.0f) {
            double angle = (double)((float)i / sides) * (Math.PI * 2);
            float sin = (float)MathHelper.sin((double)angle);
            float cos = (float)MathHelper.cos((double)angle);
            float texX = (float)i / sides;
            Vec3D point = pos.copy().radialOffset(this.facing.func_176740_k(), (double)sin, (double)cos, (double)widthStart);
            buffer.func_225582_a_(point.x, point.y, point.z).func_227885_a_(r, g, b, fadeReverse ? 0.0f : this.fxState).func_225583_a_(texX, 0.0f + beamAnimation).func_181675_d();
            point.offset(this.facing, (double)length);
            point.radialOffset(this.facing.func_176740_k(), (double)sin, (double)cos, (double)(widthEnd - widthStart));
            buffer.func_225582_a_(point.x, point.y, point.z).func_227885_a_(r, g, b, fadeReverse ? this.fxState : 0.0f).func_225583_a_(texX, 0.1f + beamAnimation).func_181675_d();
            ++i;
        }
        ccrs.draw();
    }

    public void renderWithoutShaders(CCRenderState ccrs, IVertexBuilder buffer, Vec3D pos1, float coreSize, float texOffset) {
        if (this.isInjectorEffect) {
            Vec3D pos2 = pos1.copy().offset(this.facing, 0.6);
            this.renderBeam(ccrs, buffer, pos1, 0.1f, 0.1f, 0.6f, texOffset, texOffset * 15.0f, true, energyBeamColour);
            this.renderBeam(ccrs, buffer, pos2, 0.1f, coreSize / 1.5f, this.dist - coreSize * 1.3f, texOffset + 0.1f, texOffset * 15.0f, false, energyBeamColour);
        } else {
            Vec3D pos2 = pos1.copy().offset(this.facing, 0.8);
            this.renderBeam(ccrs, buffer, pos1, 0.355f, 0.355f, 0.8f, texOffset, 0.0f, true, fieldBeamColour);
            this.renderBeam(ccrs, buffer, pos2, 0.355f, coreSize, this.dist - coreSize, texOffset + 0.1f, 0.0f, false, fieldBeamColour);
            this.renderBeam(ccrs, buffer, pos1, 0.263f, 0.263f, 0.8f, -texOffset, 0.0f, true, extractBeamColour);
            this.renderBeam(ccrs, buffer, pos2, 0.263f, coreSize / 2.0f, this.dist - coreSize * 1.3f, -texOffset + 0.1f, 0.0f, false, extractBeamColour);
        }
    }

    public void renderShaderBeam(CCRenderState ccrs, IVertexBuilder buffer, Vec3D pos, double widthStart, double widthEnd, float length, boolean fadeReverse, boolean highRes) {
        ccrs.startDrawing(5, DefaultVertexFormats.field_227851_o_);
        float sides = highRes ? 599.0f : 99.0f;
        int i = 0;
        while ((float)i < sides + 1.0f) {
            double angle = (double)((float)i / sides) * (Math.PI * 2);
            float sin = (float)MathHelper.sin((double)angle);
            float cos = (float)MathHelper.cos((double)angle);
            float texX = (float)i / sides;
            Vec3D point = pos.copy().radialOffset(this.facing.func_176740_k(), (double)sin, (double)cos, widthStart);
            buffer.func_225582_a_(point.x, point.y, point.z).func_227885_a_(1.0f, 1.0f, 1.0f, fadeReverse ? 0.0f : this.fxState).func_225583_a_(texX, fadeReverse ? 0.1f : 1.0f).func_181675_d();
            point.offset(this.facing, (double)length);
            point.radialOffset(this.facing.func_176740_k(), (double)sin, (double)cos, widthEnd - widthStart);
            buffer.func_225582_a_(point.x, point.y, point.z).func_227885_a_(1.0f, 1.0f, 1.0f, fadeReverse ? this.fxState : 0.0f).func_225583_a_(texX, 0.0f).func_181675_d();
            ++i;
        }
    }

    public IParticleRenderType func_217558_b() {
        return FX_HANDLER;
    }

    public static class FXHandler
    implements IParticleRenderType {
        private String texture;

        public FXHandler(String texture) {
            this.texture = texture;
        }

        public void func_217600_a(BufferBuilder builder, TextureManager p_217600_2_) {
            ResourceHelperDE.bindTexture(this.texture);
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.alphaFunc((int)516, (float)0.0f);
            RenderSystem.enableBlend();
            if (!DEConfig.reactorShaders) {
                RenderSystem.texParameter((int)3553, (int)10242, (int)10497);
                RenderSystem.texParameter((int)3553, (int)10243, (int)10497);
                RenderSystem.shadeModel((int)7425);
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            } else {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
        }

        public void func_217599_a(Tessellator tessellator) {
            RenderSystem.alphaFunc((int)516, (float)0.1f);
            RenderSystem.enableCull();
            if (!DEConfig.reactorShaders) {
                RenderSystem.shadeModel((int)7424);
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
        }
    }
}

