/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render;

import codechicken.lib.util.ArrayUtils;
import codechicken.lib.vec.Quat;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class EffectLib {
    private static final Vector3[] vectors = (Vector3[])ArrayUtils.fill((Object[])new Vector3[8], (Object)new Vector3());

    public static void renderLightningP2P(MatrixStack mStack, IRenderTypeBuffer getter, Vector3 startPos, Vector3 endPos, int segCount, long randSeed, float scaleMod, float deflectMod, boolean autoScale, float segTaper, int colour) {
        double height = endPos.y - startPos.y;
        float relScale = autoScale ? (float)height / 128.0f : 1.0f;
        float segHeight = (float)height / (float)segCount;
        float[] segXOffset = new float[segCount + 1];
        float[] segZOffset = new float[segCount + 1];
        float xOffSum = 0.0f;
        float zOffSum = 0.0f;
        Random random = new Random(randSeed);
        for (int segment = 0; segment < segCount + 1; ++segment) {
            segXOffset[segment] = xOffSum + (float)startPos.x;
            segZOffset[segment] = zOffSum + (float)startPos.z;
            if (segment >= segCount) continue;
            xOffSum += (5.0f - random.nextFloat() * 10.0f) * relScale * deflectMod;
            zOffSum += (5.0f - random.nextFloat() * 10.0f) * relScale * deflectMod;
        }
        xOffSum -= (float)(endPos.x - startPos.x);
        zOffSum -= (float)(endPos.z - startPos.z);
        IVertexBuilder builder = getter.getBuffer(RenderType.func_228657_l_());
        Matrix4f matrix4f = mStack.func_227866_c_().func_227870_a_();
        for (int layer = 0; layer < 4; ++layer) {
            float red = (float)(colour >> 16 & 0xFF) / 255.0f;
            float green = (float)(colour >> 8 & 0xFF) / 255.0f;
            float blue = (float)(colour & 0xFF) / 255.0f;
            float alpha = 0.3f;
            if (layer == 0) {
                alpha = 1.0f;
                blue = 1.0f;
                green = 1.0f;
                red = 1.0f;
            }
            for (int seg = 0; seg < segCount; ++seg) {
                float pos = (float)seg / (float)segCount;
                float x = segXOffset[seg] - xOffSum * pos;
                float z = segZOffset[seg] - zOffSum * pos;
                float nextPos = (float)(seg + 1) / (float)segCount;
                float nextX = segXOffset[seg + 1] - xOffSum * nextPos;
                float nextZ = segZOffset[seg + 1] - zOffSum * nextPos;
                float layerOffsetA = (0.1f + (float)layer * 0.2f * (1.0f + segTaper)) * relScale * scaleMod;
                float layerOffsetB = (0.1f + (float)layer * 0.2f * (1.0f - segTaper)) * relScale * scaleMod;
                EffectLib.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, false, false, true, false, segHeight);
                EffectLib.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, true, false, true, true, segHeight);
                EffectLib.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, true, true, false, true, segHeight);
                EffectLib.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, false, true, false, false, segHeight);
            }
        }
    }

    public static void renderLightningP2PRotate(MatrixStack mStack, IRenderTypeBuffer getter, Vector3 startPos, Vector3 endPos, int segCount, long randSeed, float scaleMod, float deflectMod, boolean autoScale, float segTaper, int colour) {
        mStack.func_227860_a_();
        double length = MathUtils.distance((Vector3)startPos, (Vector3)endPos);
        Vector3 virtualEndPos = startPos.copy().add(0.0, length, 0.0);
        Vector3 dirVec = endPos.copy();
        dirVec.subtract(startPos);
        dirVec.normalize();
        float dirVecXZDist = MathHelper.func_76133_a((double)(dirVec.x * dirVec.x + dirVec.z * dirVec.z));
        float yRot = (float)(MathHelper.func_181159_b((double)dirVec.x, (double)dirVec.z) * 57.2957763671875);
        float xRot = (float)(MathHelper.func_181159_b((double)dirVec.y, (double)dirVecXZDist) * 57.2957763671875);
        mStack.func_227861_a_(startPos.x, startPos.y, startPos.z);
        mStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yRot - 90.0f));
        mStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(xRot - 90.0f));
        mStack.func_227861_a_(-startPos.x, -startPos.y, -startPos.z);
        EffectLib.renderLightningP2P(mStack, getter, startPos, virtualEndPos, segCount, randSeed, scaleMod, deflectMod, autoScale, segTaper, colour);
        mStack.func_227865_b_();
    }

    private static void addSegmentQuad(Matrix4f matrix4f, IVertexBuilder builder, float x1, float yOffset, float z1, int segIndex, float x2, float z2, float red, float green, float blue, float alpha, float offsetA, float offsetB, boolean invA, boolean invB, boolean invC, boolean invD, float segHeight) {
        builder.func_227888_a_(matrix4f, x1 + (invA ? offsetB : -offsetB), yOffset + (float)segIndex * segHeight, z1 + (invB ? offsetB : -offsetB)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, x2 + (invA ? offsetA : -offsetA), yOffset + ((float)segIndex + 1.0f) * segHeight, z2 + (invB ? offsetA : -offsetA)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, x2 + (invC ? offsetA : -offsetA), yOffset + ((float)segIndex + 1.0f) * segHeight, z2 + (invD ? offsetA : -offsetA)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, x1 + (invC ? offsetB : -offsetB), yOffset + (float)segIndex * segHeight, z1 + (invD ? offsetB : -offsetB)).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    public static void drawParticle(ActiveRenderInfo renderInfo, IVertexBuilder builder, TextureAtlasSprite sprite, float x, float y, float z, float scale, int light) {
        Rotation rot = new Rotation(new Quat(renderInfo.func_227995_f_()));
        vectors[0].set(-1.0, -1.0, 0.0).apply((Transformation)rot).multiply((double)scale).add((double)x, (double)y, (double)z);
        vectors[1].set(-1.0, 1.0, 0.0).apply((Transformation)rot).multiply((double)scale).add((double)x, (double)y, (double)z);
        vectors[2].set(1.0, 1.0, 0.0).apply((Transformation)rot).multiply((double)scale).add((double)x, (double)y, (double)z);
        vectors[3].set(1.0, -1.0, 0.0).apply((Transformation)rot).multiply((double)scale).add((double)x, (double)y, (double)z);
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        builder.func_225582_a_(EffectLib.vectors[0].x, EffectLib.vectors[0].y, EffectLib.vectors[0].z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, vMax).func_227886_a_(light).func_181675_d();
        builder.func_225582_a_(EffectLib.vectors[1].x, EffectLib.vectors[1].y, EffectLib.vectors[1].z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, vMin).func_227886_a_(light).func_181675_d();
        builder.func_225582_a_(EffectLib.vectors[2].x, EffectLib.vectors[2].y, EffectLib.vectors[2].z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMin, vMin).func_227886_a_(light).func_181675_d();
        builder.func_225582_a_(EffectLib.vectors[3].x, EffectLib.vectors[3].y, EffectLib.vectors[3].z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMin, vMax).func_227886_a_(light).func_181675_d();
    }

    public static void drawParticle(Rotation rotation, IVertexBuilder builder, TextureAtlasSprite sprite, float r, float g, float b, double x, double y, double z, float scale, int light) {
        vectors[0].set(-1.0, -1.0, 0.0).apply((Transformation)rotation).multiply((double)scale).add(x, y, z);
        vectors[1].set(-1.0, 1.0, 0.0).apply((Transformation)rotation).multiply((double)scale).add(x, y, z);
        vectors[2].set(1.0, 1.0, 0.0).apply((Transformation)rotation).multiply((double)scale).add(x, y, z);
        vectors[3].set(1.0, -1.0, 0.0).apply((Transformation)rotation).multiply((double)scale).add(x, y, z);
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        builder.func_225582_a_(EffectLib.vectors[0].x, EffectLib.vectors[0].y, EffectLib.vectors[0].z).func_227885_a_(r, g, b, 1.0f).func_225583_a_(uMax, vMax).func_227886_a_(light).func_181675_d();
        builder.func_225582_a_(EffectLib.vectors[1].x, EffectLib.vectors[1].y, EffectLib.vectors[1].z).func_227885_a_(r, g, b, 1.0f).func_225583_a_(uMax, vMin).func_227886_a_(light).func_181675_d();
        builder.func_225582_a_(EffectLib.vectors[2].x, EffectLib.vectors[2].y, EffectLib.vectors[2].z).func_227885_a_(r, g, b, 1.0f).func_225583_a_(uMin, vMin).func_227886_a_(light).func_181675_d();
        builder.func_225582_a_(EffectLib.vectors[3].x, EffectLib.vectors[3].y, EffectLib.vectors[3].z).func_227885_a_(r, g, b, 1.0f).func_225583_a_(uMin, vMax).func_227886_a_(light).func_181675_d();
    }
}

