/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.model;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.buffer.VBORenderType;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.ShaderRenderType;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.client.model.VBOBipedModel;
import com.brandon3055.draconicevolution.client.model.tool.VBOModelRender;
import com.brandon3055.draconicevolution.client.render.item.RenderModularChestpeice;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;

public class ModularArmorModel
extends VBOBipedModel<LivingEntity> {
    public static ShaderProgram shieldShader = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("draconicevolution", "shaders/armor_shield.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/armor_shield.frag")).uniform("time", UniformType.FLOAT).uniform("activation", UniformType.FLOAT).uniform("baseColour", UniformType.VEC4)).whenUsed(cache -> cache.glUniform1f("time", ((float)BCClientEventHandler.elapsedTicks + Minecraft.func_71410_x().func_184121_ak()) / 20.0f)).build();
    private CCModel baseModel;
    private CCModel materialModel;
    private CCModel gemModel;
    private CCModel centralGemModel;
    private VBORenderType baseVBOType;
    private VBORenderType materialVBOType;
    private VBORenderType materialChaosVBOType;
    private VBORenderType gemVBOType;
    private VBORenderType centralGemVBOType;
    public RenderType modelType;
    public RenderType chaosType;
    public RenderType shieldType;
    public RenderType shaderParentType;
    private float shieldState = 0.0f;
    private int shieldColour = 65280;
    private boolean onArmor;

    public ModularArmorModel(float size, TechLevel techLevel, boolean onArmor) {
        super(size);
        this.onArmor = onArmor;
        float yOffsetIn = 0.0f;
        Map model = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/item/equipment/chestpeice.obj"), (int)4, null);
        this.baseModel = CCModel.combine(Collections.singletonList(model.get("base_model"))).backfacedCopy();
        this.materialModel = ((CCModel)model.get("chevrons")).backfacedCopy();
        this.gemModel = ((CCModel)model.get("power_crystals")).backfacedCopy();
        this.centralGemModel = ((CCModel)model.get("crystal_core")).backfacedCopy();
        if (onArmor) {
            this.materialModel.apply((Transformation)new Translation(0.0, 0.0, -0.0625));
            this.gemModel.apply((Transformation)new Translation(0.0, 0.0, -0.03125));
            this.centralGemModel.apply((Transformation)new Translation(0.0, 0.0, -0.03125));
        }
        String levelName = techLevel.name().toLowerCase(Locale.ENGLISH);
        this.modelType = RenderType.func_228633_a_((String)"modelType", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/item/equipment/" + levelName + "_chestpeice.png"), false, false)).func_228716_a_(RenderState.field_228532_x_).func_228719_a_(RenderState.field_228528_t_).func_228728_a_(true));
        this.chaosType = RenderType.func_228632_a_((String)"chaosShaderType", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)4, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/item/equipment/chaos_shader.png"), true, false)).func_228719_a_(RenderState.field_228528_t_).func_228722_a_(RenderState.field_228530_v_).func_228728_a_(false));
        this.shaderParentType = RenderType.func_228632_a_((String)"shaderGemType", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)4, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228716_a_(RenderState.field_228532_x_).func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/item/equipment/shader_fallback_" + levelName + ".png"), false, false)).func_228719_a_(RenderState.field_228528_t_).func_228722_a_(RenderState.field_228530_v_).func_228728_a_(false));
        this.shieldType = RenderType.func_228632_a_((String)"shieldType", (VertexFormat)DefaultVertexFormats.field_227850_m_, (int)4, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228716_a_(RenderState.field_228532_x_).func_228726_a_(RenderState.field_228515_g_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228719_a_(RenderState.field_228528_t_).func_228714_a_(RenderState.field_228491_A_).func_228728_a_(false));
        this.baseVBOType = new VBORenderType(this.modelType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            if (!onArmor) {
                CCRenderState ccrs = CCRenderState.instance();
                ccrs.reset();
                ccrs.bind((IVertexBuilder)builder, format);
                this.baseModel.render(ccrs, new IVertexOperation[0]);
            }
        });
        this.materialVBOType = new VBORenderType(this.modelType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.materialModel.render(ccrs, new IVertexOperation[0]);
        });
        this.materialChaosVBOType = new VBORenderType(this.chaosType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.materialModel.render(ccrs, new IVertexOperation[0]);
        });
        this.gemVBOType = new VBORenderType(this.shaderParentType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.gemModel.render(ccrs, new IVertexOperation[0]);
        });
        this.centralGemVBOType = new VBORenderType(this.shaderParentType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.centralGemModel.render(ccrs, new IVertexOperation[0]);
        });
        CCModel shieldHeadModel = ((CCModel)model.get("shield_head")).backfacedCopy();
        VBORenderType shieldHeadVBO = new VBORenderType(this.shieldType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            ccrs.baseColour = -192;
            shieldHeadModel.render(ccrs, new IVertexOperation[0]);
        });
        CCModel shieldBodyModel = ((CCModel)model.get("shield_body")).backfacedCopy();
        VBORenderType shieldBodyVBO = new VBORenderType(this.shieldType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            ccrs.baseColour = -192;
            shieldBodyModel.render(ccrs, new IVertexOperation[0]);
        });
        CCModel shieldRightArmModel = ((CCModel)model.get("shield_right_arm")).backfacedCopy();
        VBORenderType shieldRightArmVBO = new VBORenderType(this.shieldType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            ccrs.baseColour = -192;
            shieldRightArmModel.render(ccrs, new IVertexOperation[0]);
        });
        CCModel shieldLeftArmModel = ((CCModel)model.get("shield_left_arm")).backfacedCopy();
        VBORenderType shieldLeftArmVBO = new VBORenderType(this.shieldType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            ccrs.baseColour = -192;
            shieldLeftArmModel.render(ccrs, new IVertexOperation[0]);
        });
        CCModel shieldRightLegModel = ((CCModel)model.get("shield_right_leg")).backfacedCopy();
        VBORenderType shieldRightLegVBO = new VBORenderType(this.shieldType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            ccrs.baseColour = -192;
            shieldRightLegModel.render(ccrs, new IVertexOperation[0]);
        });
        CCModel shieldLeftLegModel = ((CCModel)model.get("shield_left_leg")).backfacedCopy();
        VBORenderType shieldLeftLegVBO = new VBORenderType(this.shieldType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            ccrs.baseColour = -192;
            shieldLeftLegModel.render(ccrs, new IVertexOperation[0]);
        });
        this.bipedBody = new VBOModelRender((Model)this, this.baseVBOType);
        this.bipedBody.func_78793_a(0.0f, 0.0f + yOffsetIn, 0.0f);
        VBOModelRender matRender = new VBOModelRender((Model)this, techLevel == TechLevel.CHAOTIC ? this.materialChaosVBOType : this.materialVBOType);
        if (techLevel == TechLevel.CHAOTIC) {
            matRender.setShader(() -> RenderModularChestpeice.getShaderType(this.chaosType, RenderModularChestpeice.chaosShader));
        }
        this.bipedBody.func_78792_a(matRender);
        this.bipedBody.func_78792_a(new VBOModelRender((Model)this, this.gemVBOType).setShader(() -> RenderModularChestpeice.getShaderType(this.shaderParentType, techLevel, RenderModularChestpeice.gemShader)));
        this.bipedBody.func_78792_a(new VBOModelRender((Model)this, this.centralGemVBOType).setShader(() -> RenderModularChestpeice.getShaderType(this.shaderParentType, techLevel, this.shieldColour, RenderModularChestpeice.coreShader)));
        this.bipedBody.func_78792_a(new VBOModelRender((Model)this, shieldBodyVBO, () -> this.shieldState > 0.0f).setShader(() -> ModularArmorModel.getShaderType(this.shieldType, techLevel, this.shieldState, this.shieldColour, shieldShader)));
        this.bipedHead = new VBOModelRender((Model)this, shieldHeadVBO, () -> this.shieldState > 0.0f).setShader(() -> ModularArmorModel.getShaderType(this.shieldType, techLevel, this.shieldState, this.shieldColour, shieldShader));
        this.bipedHead.func_78793_a(0.0f, 0.0f + yOffsetIn, 0.0f);
        this.bipedRightArm = new VBOModelRender((Model)this, shieldRightArmVBO, () -> this.shieldState > 0.0f).setShader(() -> ModularArmorModel.getShaderType(this.shieldType, techLevel, this.shieldState, this.shieldColour, shieldShader));
        this.bipedRightArm.func_78793_a(-5.0f, 2.0f + yOffsetIn, 0.0f);
        this.bipedLeftArm = new VBOModelRender((Model)this, shieldLeftArmVBO, () -> this.shieldState > 0.0f).setShader(() -> ModularArmorModel.getShaderType(this.shieldType, techLevel, this.shieldState, this.shieldColour, shieldShader));
        this.bipedLeftArm.field_78809_i = true;
        this.bipedLeftArm.func_78793_a(5.0f, 2.0f + yOffsetIn, 0.0f);
        this.bipedRightLeg = new VBOModelRender((Model)this, shieldRightLegVBO, () -> this.shieldState > 0.0f).setShader(() -> ModularArmorModel.getShaderType(this.shieldType, techLevel, this.shieldState, this.shieldColour, shieldShader));
        this.bipedRightLeg.func_78793_a(-1.9f, 12.0f + yOffsetIn, 0.0f);
        this.bipedLeftLeg = new VBOModelRender((Model)this, shieldLeftLegVBO, () -> this.shieldState > 0.0f).setShader(() -> ModularArmorModel.getShaderType(this.shieldType, techLevel, this.shieldState, this.shieldColour, shieldShader));
        this.bipedLeftLeg.field_78809_i = true;
        this.bipedLeftLeg.func_78793_a(1.9f, 12.0f + yOffsetIn, 0.0f);
    }

    @Override
    public void render(MatrixStack mStack, IRenderTypeBuffer getter, LivingEntity player, ItemStack stack, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ModuleHost host;
        ShieldControlEntity shieldControl;
        this.shieldState = 0.0f;
        this.shieldColour = -1;
        LazyOptional optionalHost = stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        if (!stack.func_190926_b() && optionalHost.isPresent() && (shieldControl = (ShieldControlEntity)(host = (ModuleHost)optionalHost.orElseThrow(IllegalStateException::new)).getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null)) != null) {
            this.shieldState = shieldControl.getShieldState();
            this.shieldColour = shieldControl.getShieldColour();
        }
        if (this.field_217114_e) {
            mStack.func_227860_a_();
            if (this.field_228221_a_) {
                float f = 1.5f / this.field_228224_g_;
                mStack.func_227862_a_(f, f, f);
            }
            mStack.func_227861_a_(0.0, (double)(this.field_228222_b_ / 16.0f), (double)(this.field_228223_f_ / 16.0f));
            this.bipedHead.render(mStack, getter, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            mStack.func_227865_b_();
            mStack.func_227860_a_();
            float f1 = 1.0f / this.field_228225_h_;
            mStack.func_227862_a_(f1, f1, f1);
            mStack.func_227861_a_(0.0, (double)(this.field_228226_i_ / 16.0f), 0.0);
            this.bipedBody.render(mStack, getter, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.bipedLeftArm.render(mStack, getter, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.bipedRightArm.render(mStack, getter, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.bipedLeftLeg.render(mStack, getter, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.bipedRightLeg.render(mStack, getter, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            mStack.func_227865_b_();
        } else {
            this.bipedBody.render(mStack, getter, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.bipedHead.render(mStack, getter, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.bipedLeftArm.render(mStack, getter, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.bipedRightArm.render(mStack, getter, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.bipedLeftLeg.render(mStack, getter, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.bipedRightLeg.render(mStack, getter, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }

    public static ShaderRenderType getShaderType(RenderType parent, TechLevel techLevel, float activation, int colour, ShaderProgram shader) {
        UniformCache uniforms = shader.pushCache();
        uniforms.glUniform1f("activation", activation);
        uniforms.glUniform4f("baseColour", (float)(colour >> 16 & 0xFF) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f, (float)(colour >> 24 & 0xFF) / 63.0f);
        return new ShaderRenderType(parent, shader, uniforms);
    }
}

