/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.flowgate;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFlowGate;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;

public class TileFluxGate
extends TileFlowGate {
    private OPRegulator inputReg = new OPRegulator(this, true);
    private OPRegulator outputReg = new OPRegulator(this, false);
    private boolean capsLoaded = false;

    public TileFluxGate() {
        super(DEContent.tile_flux_gate);
    }

    @Override
    public String getUnits() {
        return "RF/t";
    }

    private void updateCapabilities() {
        this.capManager.remove(CapabilityOP.OP, new Direction[0]);
        this.capManager.set(CapabilityOP.OP, (Object)this.inputReg, new Direction[]{this.getDirection().func_176734_d()});
        this.capManager.set(CapabilityOP.OP, (Object)this.outputReg, new Direction[]{this.getDirection()});
    }

    @Override
    public void func_145836_u() {
        super.func_145836_u();
        this.updateCapabilities();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (!this.capsLoaded) {
            this.updateCapabilities();
            this.capsLoaded = true;
        }
        return super.getCapability(capability, side);
    }

    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerBCTile(DEContent.container_flow_gate, id, player.field_71071_by, (TileBCore)this, (ContainerSlotLayout.LayoutFactory)SneakyUtils.unsafeCast(GuiLayoutFactories.PLAYER_ONLY_LAYOUT));
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
        }
        return true;
    }

    @Override
    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        if (this.flowOverridden.get()) {
            return;
        }
        try {
            String value = data.readString();
            long l = Long.parseLong(value);
            if (l < 0L) {
                l = 0L;
            }
            if (id == 0) {
                this.minFlow.set(l);
            } else if (id == 1) {
                this.maxFlow.set(l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static class OPRegulator
    implements IOPStorage {
        private TileFluxGate tile;
        private boolean isInput;

        public OPRegulator(TileFluxGate tile, boolean isInput) {
            this.tile = tile;
            this.isInput = isInput;
        }

        public long receiveOP(long maxReceive, boolean simulate) {
            if (this.isInput) {
                TileEntity target = this.tile.getTarget();
                if (target == null) {
                    return 0L;
                }
                Direction tInputSide = this.tile.getDirection().func_176734_d();
                long sim = EnergyUtils.insertEnergy((TileEntity)target, (long)maxReceive, (Direction)tInputSide, (boolean)true);
                long transfer = EnergyUtils.insertEnergy((TileEntity)target, (long)Math.min(Math.max(0L, this.tile.getFlow() - this.tile.transferThisTick), sim), (Direction)tInputSide, (boolean)simulate);
                if (!simulate) {
                    this.tile.transferThisTick += transfer;
                }
                return transfer;
            }
            return 0L;
        }

        public long extractOP(long maxExtract, boolean simulate) {
            if (!this.isInput) {
                TileEntity source = this.tile.getSource();
                if (source == null) {
                    return 0L;
                }
                Direction tExtractSide = this.tile.getDirection();
                long sim = EnergyUtils.extractEnergy((TileEntity)source, (long)maxExtract, (Direction)tExtractSide, (boolean)true);
                long transfer = EnergyUtils.extractEnergy((TileEntity)source, (long)Math.min(Math.max(0L, this.tile.getFlow() - this.tile.transferThisTick), sim), (Direction)tExtractSide, (boolean)simulate);
                if (!simulate) {
                    this.tile.transferThisTick += transfer;
                }
                return transfer;
            }
            return 0L;
        }

        public long getOPStored() {
            if (this.isInput) {
                return 0L;
            }
            TileEntity target = this.tile.getTarget();
            if (target == null) {
                return 0L;
            }
            return EnergyUtils.getEnergyStored((TileEntity)target, (Direction)this.tile.getDirection().func_176734_d());
        }

        public long getMaxOPStored() {
            if (this.isInput) {
                return 0L;
            }
            TileEntity target = this.tile.getTarget();
            if (target == null) {
                return 0L;
            }
            return EnergyUtils.getMaxEnergyStored((TileEntity)target, (Direction)this.tile.getDirection().func_176734_d());
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return (int)this.receiveOP(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return (int)this.extractOP(maxExtract, simulate);
        }

        public int getEnergyStored() {
            return (int)Math.min(Integer.MAX_VALUE, this.getOPStored());
        }

        public int getMaxEnergyStored() {
            return (int)Math.min(Integer.MAX_VALUE, this.getMaxOPStored());
        }

        public boolean canExtract() {
            return !this.isInput;
        }

        public boolean canReceive() {
            return this.isInput;
        }
    }
}

