/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;

public class TilePlacedItem
extends TileBCore
implements IInteractTile {
    public static int MAX_STACKS = 4;
    public final ManagedByte stackCount = (ManagedByte)this.register((IManagedData)new ManagedByte("stack_count", 1, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool toolMode = (ManagedBool)this.register((IManagedData)new ManagedBool("tool_mode", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte[] rotation = new ManagedByte[MAX_STACKS];
    public final ManagedBool[] isBlock = new ManagedBool[MAX_STACKS];
    public TileItemStackHandler itemHandler = new TileItemStackHandler(MAX_STACKS);

    public TilePlacedItem() {
        super(DEContent.tile_placed_item);
        for (int i = 0; i < MAX_STACKS; ++i) {
            this.rotation[i] = (ManagedByte)this.register((IManagedData)new ManagedByte("rotation_" + i, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
            this.isBlock[i] = (ManagedBool)this.register((IManagedData)new ManagedBool("is_block_" + i, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
        }
        this.capManager.setInternalManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler).saveBoth().syncTile();
        this.itemHandler.setContentsChangeListener(e -> this.updatePlacedItem());
    }

    private void updatePlacedItem() {
        List<ItemStack> stacks = this.getStacksInOrder();
        this.stackCount.set(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            this.isBlock[i].set(stacks.get(i).func_77973_b() instanceof BlockItem);
        }
        if (stacks.size() == 1) {
            ItemStack stack = stacks.get(0);
            this.toolMode.set(!stack.getToolTypes().isEmpty() || stack.func_77984_f());
        } else {
            this.toolMode.set(false);
        }
        this.tick();
    }

    public List<ItemStack> getStacksInOrder() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = this.itemHandler.getSlots() - 1; i >= 0; --i) {
            if (this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            stacks.add(this.itemHandler.getStackInSlot(i));
        }
        return stacks;
    }

    public ItemStack extractStackAtIndex(int index) {
        int current = 0;
        for (int i = this.itemHandler.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (index == current) {
                this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                return stack;
            }
            ++current;
        }
        return ItemStack.field_190927_a;
    }

    public boolean[] getBlockArray() {
        boolean[] bools = new boolean[MAX_STACKS];
        for (int i = 0; i < MAX_STACKS; ++i) {
            bools[i] = this.isBlock[i].get();
        }
        return bools;
    }

    public ActionResultType onBlockUse(BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.field_70170_p.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        List<ItemStack> stacks = this.getStacksInOrder();
        int index = hit.subHit - 1;
        if (player.func_225608_bj_()) {
            if (index >= 0 && index < this.rotation.length) {
                this.rotation[index].inc();
                BCoreNetwork.sendSound((World)this.field_145850_b, (BlockPos)this.field_174879_c, (SoundEvent)SoundEvents.field_187632_cP, (SoundCategory)SoundCategory.PLAYERS, (float)1.0f, (float)(0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f), (boolean)false);
                this.tick();
            }
            return ActionResultType.SUCCESS;
        }
        if (index == -1) {
            this.onBroken(Vector3.fromEntityCenter((Entity)player), true);
            this.field_145850_b.func_217377_a(this.func_174877_v(), false);
            return ActionResultType.SUCCESS;
        }
        if (index < stacks.size()) {
            ItemStack stack = this.extractStackAtIndex(index);
            InventoryUtils.givePlayerStack((PlayerEntity)player, (ItemStack)stack);
            if (stacks.size() == 1) {
                this.field_145850_b.func_217377_a(this.func_174877_v(), false);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void onBlockAttack(BlockState state, PlayerEntity player) {
        if (!player.func_225608_bj_()) {
            return;
        }
        List<ItemStack> stacks = this.getStacksInOrder();
        if (stacks.size() == 1 && !(stacks.get(0).func_77973_b() instanceof BlockItem)) {
            this.toolMode.invert();
            BCoreNetwork.sendSound((World)this.field_145850_b, (BlockPos)this.field_174879_c, (SoundEvent)SoundEvents.field_187632_cP, (SoundCategory)SoundCategory.PLAYERS, (float)1.0f, (float)(0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f), (boolean)false);
            this.tick();
        } else {
            RayTraceResult hit = player.func_213324_a(4.0, 0.0f, false);
            if (hit instanceof BlockRayTraceResult && hit.subHit > 0 && hit.subHit - 1 < this.rotation.length) {
                this.rotation[hit.subHit - 1].dec();
                BCoreNetwork.sendSound((World)this.field_145850_b, (BlockPos)this.field_174879_c, (SoundEvent)SoundEvents.field_187632_cP, (SoundCategory)SoundCategory.PLAYERS, (float)1.0f, (float)(0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f), (boolean)false);
                this.tick();
            }
        }
    }

    public void onBroken(Vector3 dropPos, boolean noPickupDelay) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            TilePlacedItem.popResource(this.field_145850_b, dropPos, this.itemHandler.getStackInSlot(i), noPickupDelay);
            this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public static void popResource(World world, Vector3 pos, ItemStack stack, boolean noPickupDelay) {
        if (!world.field_72995_K && !stack.func_190926_b() && world.func_82736_K().func_223586_b(GameRules.field_223603_f) && !world.restoringBlockSnapshots) {
            double d0 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            ItemEntity itementity = new ItemEntity(world, pos.x + d0, pos.y + d1, pos.z + d2, stack);
            if (noPickupDelay) {
                itementity.func_174868_q();
            } else {
                itementity.func_174869_p();
            }
            world.func_217376_c((Entity)itementity);
        }
    }

    public boolean saveToItem() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, -1, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }
}

