/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.colour.Colour;
import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.api.power.IExtendedRFStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedDouble;
import com.brandon3055.brandonscore.lib.datamanager.ManagedLong;
import com.brandon3055.brandonscore.lib.datamanager.ManagedString;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.blocks.machines.EnergyCore;
import com.brandon3055.draconicevolution.blocks.tileentity.IMultiBlockPart;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.brandon3055.draconicevolution.lib.EnergyCoreBuilder;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.brandon3055.draconicevolution.world.EnergyCoreStructure;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class TileEnergyCore
extends TileBCore
implements ITickableTileEntity,
IExtendedRFStorage,
IMultiBlockPart,
INamedContainerProvider {
    public int frameMoveContactPoints = 0;
    public boolean isFrameMoving = false;
    public boolean moveBlocksProvided = false;
    public static final byte ORIENT_UNKNOWN = 0;
    public static final byte ORIENT_UP_DOWN = 1;
    public static final byte ORIENT_NORTH_SOUTH = 2;
    public static final byte ORIENT_EAST_WEST = 3;
    public static final Direction[][] STAB_ORIENTATIONS = new Direction[][]{new Direction[0], Direction.field_176754_o, {Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, {Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH}};
    public final EnergyCoreStructure coreStructure = new EnergyCoreStructure().initialize(this);
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedBool structureValid = (ManagedBool)this.register((IManagedData)new ManagedBool("structure_valid", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedBool coreValid = (ManagedBool)this.register((IManagedData)new ManagedBool("core_valid", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedString invalidMessage = (ManagedString)this.register((IManagedData)new ManagedString("invalid_message", new DataFlags[]{DataFlags.SAVE_NBT}));
    public final ManagedBool buildGuide = (ManagedBool)this.register((IManagedData)new ManagedBool("build_guide", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedBool stabilizersOK = (ManagedBool)this.register((IManagedData)new ManagedBool("stabilizers_ok", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedByte tier = (ManagedByte)this.register((IManagedData)new ManagedByte("tier", 1, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedLong energy = (ManagedLong)this.register((IManagedData)new ManagedLong("energy", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedVec3I[] stabOffsets = new ManagedVec3I[4];
    public final ManagedLong transferRate = (ManagedLong)this.register((IManagedData)new ManagedLong("transfer_rate", new DataFlags[]{DataFlags.SYNC_CONTAINER}));
    public final ManagedDouble inputRate = (ManagedDouble)this.register((IManagedData)new ManagedDouble("input_rate", new DataFlags[]{DataFlags.SYNC_CONTAINER}));
    public final ManagedDouble outputRate = (ManagedDouble)this.register((IManagedData)new ManagedDouble("output_rate", new DataFlags[]{DataFlags.SYNC_CONTAINER}));
    private int ticksElapsed = 0;
    private long[] flowArray = new long[20];
    private EnergyCoreBuilder activeBuilder = null;
    public float rotation = 0.0f;
    private long lastTickEnergy = 0L;
    private long lastTickInput = 0L;
    private long lastTickOutput = 0L;

    public TileEnergyCore() {
        super(DEContent.tile_storage_core);
        for (int i = 0; i < this.stabOffsets.length; ++i) {
            this.stabOffsets[i] = (ManagedVec3I)this.register((IManagedData)new ManagedVec3I("stab_offset" + i, new Vec3I(0, -1, 0), new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
        }
        this.active.addValueListener(active -> {
            if (this.field_145850_b != null) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)EnergyCore.ACTIVE, (Comparable)active));
            }
        });
    }

    public int getAccessDistanceSq() {
        return 1024;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.flowArray[this.ticksElapsed % 20] = this.energy.get() - this.lastTickEnergy;
            this.lastTickEnergy = this.energy.get();
            long total = 0L;
            for (long i : this.flowArray) {
                total += i;
            }
            this.transferRate.set(total / 20L);
            if (this.activeBuilder != null) {
                if (this.activeBuilder.isDead()) {
                    this.activeBuilder = null;
                } else {
                    this.activeBuilder.updateProcess();
                }
            }
            if (this.ticksElapsed % 500 == 0) {
                this.validateStructure();
            }
            double diff = (double)this.lastTickInput - this.inputRate.get();
            this.inputRate.add(diff / 10.0);
            diff = (double)this.lastTickOutput - this.outputRate.get();
            this.outputRate.add(diff / 10.0);
            this.lastTickOutput = 0L;
            this.lastTickInput = 0L;
        } else {
            this.rotation += 1.0f;
        }
        super.tick();
        if (this.ticksElapsed % 20 == 0 && !this.field_145850_b.field_72995_K && this.transferRate.isDirty(true)) {
            this.dataManager.forceSync((IManagedData)this.transferRate);
        }
        if (this.field_145850_b.field_72995_K && this.active.get()) {
            List players = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b(10.0, 10.0, 10.0));
            for (PlayerEntity player : players) {
                double dist = Vec3D.getCenter((TileEntity)this).distance(new Vec3D((Entity)player));
                double distNext = new Vec3D((Entity)player).distance(new Vec3D((double)this.field_174879_c.func_177958_n() + player.func_213322_ci().field_72450_a + 0.5, (double)this.field_174879_c.func_177956_o() + player.func_213322_ci().field_72448_b - 0.4, (double)this.field_174879_c.func_177952_p() + player.func_213322_ci().field_72449_c + 0.5));
                double threshold = this.tier.get() > 2 ? (double)this.tier.get() - 0.5 : (double)this.tier.get() + 0.5;
                double boundary = distNext - threshold;
                double dir = dist - distNext;
                if (!(boundary <= 0.0)) continue;
                if (dir < 0.0) {
                    player.func_213315_a(MoverType.PLAYER, new Vector3d(-player.func_213322_ci().field_72450_a * 1.5, -player.func_213322_ci().field_72448_b * 1.5, -player.func_213322_ci().field_72449_c * 1.5));
                }
                double multiplier = (threshold - dist) * 0.05;
                double xm = ((double)this.field_174879_c.func_177958_n() + 0.5 - player.func_226277_ct_()) / distNext * multiplier;
                double ym = ((double)this.field_174879_c.func_177956_o() - 0.4 - player.func_226278_cu_()) / distNext * multiplier;
                double zm = ((double)this.field_174879_c.func_177952_p() + 0.5 - player.func_226281_cx_()) / distNext * multiplier;
                player.func_213315_a(MoverType.PLAYER, new Vector3d(-xm, -ym, -zm));
            }
        }
        ++this.ticksElapsed;
    }

    @Nullable
    public Container createMenu(int currentWindowIndex, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerBCTile(DEContent.container_energy_core, currentWindowIndex, player.field_71071_by, (TileBCore)this, GuiLayoutFactories.ENERGY_CORE_LAYOUT);
    }

    public void onStructureClicked(World world, BlockPos blockClicked, BlockState state, PlayerEntity player) {
        if (!world.field_72995_K) {
            this.validateStructure();
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
            }
        }
    }

    public void activateCore() {
        if (this.field_145850_b.field_72995_K || !this.validateStructure()) {
            return;
        }
        if (this.energy.get() > this.getCapacity()) {
            this.energy.set(this.getCapacity());
        }
        this.buildGuide.set(false);
        this.coreStructure.formTier(this.tier.get());
        this.active.set(true);
        this.updateStabilizers(true);
    }

    public void deactivateCore() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.coreStructure.revertTier(this.tier.get());
        this.active.set(false);
        this.updateStabilizers(false);
    }

    private long getCapacity() {
        if (this.tier.get() <= 0 || this.tier.get() > 8) {
            LogHelper.error("Tier not valid! WTF!!!");
            return 0L;
        }
        return (long)DEOldConfig.coreCapacity[this.tier.get() - 1];
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        if (id == 0) {
            if (this.active.get()) {
                this.deactivateCore();
            } else {
                this.activateCore();
            }
        } else if (id == 1) {
            if (!this.active.get() && this.tier.get() < 8) {
                this.tier.inc();
                this.validateStructure();
            }
        } else if (id == 2) {
            if (!this.active.get() && this.tier.get() > 1) {
                this.tier.dec();
                this.validateStructure();
            }
        } else if (id == 3) {
            if (!this.active.get()) {
                this.buildGuide.set(!this.buildGuide.get());
            }
        } else if (id == 4 && !this.active.get()) {
            this.startBuilder((PlayerEntity)client);
        }
    }

    private void startBuilder(PlayerEntity player) {
        if (this.activeBuilder != null && !this.activeBuilder.isDead()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("ecore.de.already_assembling.txt").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        } else {
            this.activeBuilder = new EnergyCoreBuilder(this, player);
        }
    }

    private void updateStabilizers(boolean coreActive) {
        for (ManagedVec3I offset : this.stabOffsets) {
            BlockPos tilePos = this.field_174879_c.func_177982_a(-offset.get().x, -offset.get().y, -offset.get().z);
            TileEntity tile = this.field_145850_b.func_175625_s(tilePos);
            if (!(tile instanceof TileEnergyCoreStabilizer)) continue;
            ((TileEnergyCoreStabilizer)tile).isCoreActive.set(coreActive);
        }
    }

    @Override
    public boolean validateStructure() {
        boolean valid = this.checkStabilizers();
        if (!this.coreValid.set(this.coreStructure.checkTier(this.tier.get()))) {
            BlockPos pos = this.coreStructure.invalidBlock;
            this.invalidMessage.set("Error At: x:" + pos.func_177958_n() + ", y:" + pos.func_177956_o() + ", z:" + pos.func_177952_p() + " Expected: " + this.coreStructure.expectedBlock);
            valid = false;
        }
        if (!valid && this.active.get()) {
            this.active.set(false);
            this.deactivateCore();
        }
        this.structureValid.set(valid);
        if (valid) {
            this.invalidMessage.set("");
        }
        return valid;
    }

    public boolean checkStabilizers() {
        boolean flag = true;
        if (this.stabilizersOK.get()) {
            for (ManagedVec3I offset : this.stabOffsets) {
                BlockPos tilePos = this.field_174879_c.func_177973_b((Vector3i)offset.get().getPos());
                TileEntity tile = this.field_145850_b.func_175625_s(tilePos);
                if (tile instanceof TileEnergyCoreStabilizer && ((TileEnergyCoreStabilizer)tile).hasCoreLock.get() && ((TileEnergyCoreStabilizer)tile).getCore() == this && ((TileEnergyCoreStabilizer)tile).isStabilizerValid(this.tier.get(), this)) continue;
                flag = false;
                break;
            }
            if (!flag) {
                this.stabilizersOK.set(false);
                this.releaseStabilizers();
            }
        } else {
            for (int orient = 1; orient < STAB_ORIENTATIONS.length; ++orient) {
                Direction[] dirs = STAB_ORIENTATIONS[orient];
                ArrayList<TileEnergyCoreStabilizer> stabsFound = new ArrayList<TileEnergyCoreStabilizer>();
                block2: for (int fIndex = 0; fIndex < dirs.length; ++fIndex) {
                    Direction facing = dirs[fIndex];
                    for (int dist = 0; dist < 16; ++dist) {
                        TileEnergyCoreStabilizer stabilizer;
                        TileEnergyCore currentCore;
                        BlockPos pos1 = this.field_174879_c.func_177982_a(facing.func_82601_c() * dist, facing.func_96559_d() * dist, facing.func_82599_e() * dist);
                        TileEntity tile = this.field_145850_b.func_175625_s(pos1);
                        if (!(tile instanceof TileEnergyCoreStabilizer) || (currentCore = (stabilizer = (TileEnergyCoreStabilizer)tile).getCore()) != null && stabilizer.getCore() != this || !stabilizer.isStabilizerValid(this.tier.get(), this)) continue;
                        stabsFound.add(stabilizer);
                        continue block2;
                    }
                }
                if (stabsFound.size() == 4) {
                    for (TileEnergyCoreStabilizer stab : stabsFound) {
                        this.stabOffsets[stabsFound.indexOf(stab)].set(new Vec3I(this.field_174879_c.func_177958_n() - stab.func_174877_v().func_177958_n(), this.field_174879_c.func_177956_o() - stab.func_174877_v().func_177956_o(), this.field_174879_c.func_177952_p() - stab.func_174877_v().func_177952_p()));
                        stab.setCore(this);
                    }
                    this.stabilizersOK.set(true);
                    break;
                }
                flag = false;
            }
        }
        return flag;
    }

    private void releaseStabilizers() {
        for (ManagedVec3I offset : this.stabOffsets) {
            BlockPos tilePos = this.field_174879_c.func_177982_a(-offset.get().x, -offset.get().y, -offset.get().z);
            TileEntity tile = this.field_145850_b.func_175625_s(tilePos);
            if (tile instanceof TileEnergyCoreStabilizer) {
                ((TileEnergyCoreStabilizer)tile).hasCoreLock.set(false);
                ((TileEnergyCoreStabilizer)tile).coreOffset.get().y = 0;
            }
            offset.set(new Vec3I(0, -1, 0));
        }
    }

    public long receiveEnergy(long maxReceive, boolean simulate) {
        if (this.field_145850_b.field_72995_K) {
            return 0L;
        }
        long energyReceived = Math.min(this.getExtendedCapacity() - this.energy.get(), maxReceive);
        if (!simulate) {
            this.energy.add(energyReceived);
            this.lastTickInput += energyReceived;
            this.func_70296_d();
        }
        return energyReceived;
    }

    public long extractEnergy(long maxExtract, boolean simulate) {
        if (this.field_145850_b.field_72995_K) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy.get(), maxExtract);
        if (!simulate) {
            this.energy.subtract(energyExtracted);
            this.lastTickOutput += energyExtracted;
            this.func_70296_d();
        }
        return energyExtracted;
    }

    public long getExtendedStorage() {
        return this.energy.get();
    }

    public long getExtendedCapacity() {
        return this.getCapacity();
    }

    @Override
    public boolean isStructureValid() {
        return this.structureValid.get();
    }

    @Override
    public IMultiBlockPart getController() {
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public int getColour() {
        if (this.tier.get() == 8) {
            return Colour.packRGBA((double)1.0, (double)0.28f, (double)0.05f, (double)1.0);
        }
        float colour = 1.0f - (float)this.getExtendedStorage() / (float)this.getExtendedCapacity();
        return Colour.packRGBA((double)1.0, (double)(colour * 0.3f), (double)(colour * 0.7f), (double)1.0);
    }
}

