/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedString;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.draconicevolution.blocks.tileentity.IMultiBlockPart;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyPylon;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.registries.ForgeRegistries;

public class TileCoreStructure
extends TileBCore
implements IMultiBlockPart,
IInteractTile {
    public final ManagedVec3I coreOffset = (ManagedVec3I)this.register((IManagedData)new ManagedVec3I("core_offset", new Vec3I(0, -1, 0), new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.SYNC_ON_SET}));
    public final ManagedString blockName = (ManagedString)this.register((IManagedData)new ManagedString("block_name", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.SYNC_ON_SET}));

    public TileCoreStructure() {
        super(DEContent.tile_core_structure);
    }

    @Override
    public boolean isStructureValid() {
        return this.getController() != null && this.getController().isStructureValid();
    }

    @Override
    public IMultiBlockPart getController() {
        TileEntity tile = this.field_145850_b.func_175625_s(this.getCorePos());
        if (tile instanceof IMultiBlockPart) {
            return (IMultiBlockPart)tile;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.revert();
        }
        return null;
    }

    @Override
    public boolean validateStructure() {
        IMultiBlockPart master = this.getController();
        if (master == null) {
            this.revert();
            return false;
        }
        return master.validateStructure();
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        IMultiBlockPart controller = this.getController();
        if (controller instanceof TileEnergyCoreStabilizer) {
            ((TileEnergyCoreStabilizer)controller).onBlockActivated(state, player, handIn, hit);
        } else if (controller instanceof TileEnergyCore) {
            ((TileEnergyCore)controller).onStructureClicked(this.field_145850_b, this.field_174879_c, state, player);
        } else if (controller instanceof TileEnergyPylon) {
            ((TileEnergyPylon)controller).invertIO();
        }
        return true;
    }

    public void revert() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(this.blockName.get()));
        if (block != Blocks.field_150350_a) {
            this.field_145850_b.func_175656_a(this.field_174879_c, block.func_176223_P());
        } else {
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
    }

    public void setController(IMultiBlockPart controller) {
        this.coreOffset.set(new Vec3I(this.field_174879_c.func_177973_b((Vector3i)((TileEntity)controller).func_174877_v())));
    }

    private BlockPos getCorePos() {
        return this.field_174879_c.func_177982_a(-this.coreOffset.get().x, -this.coreOffset.get().y, -this.coreOffset.get().z);
    }
}

