/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePotentiometer;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class Potentiometer
extends BlockBCore {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    protected static final VoxelShape AABB_DOWN = VoxelShapes.func_197873_a((double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
    protected static final VoxelShape AABB_UP = VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375);
    protected static final VoxelShape AABB_NORTH = VoxelShapes.func_197873_a((double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.9375, (double)1.0);
    protected static final VoxelShape AABB_SOUTH = VoxelShapes.func_197873_a((double)0.0625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.0625);
    protected static final VoxelShape AABB_WEST = VoxelShapes.func_197873_a((double)0.9375, (double)0.0625, (double)0.0625, (double)1.0, (double)0.9375, (double)0.9375);
    protected static final VoxelShape AABB_EAST = VoxelShapes.func_197873_a((double)0.0, (double)0.0625, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375);

    public Potentiometer(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP));
        this.canProvidePower = true;
    }

    public boolean isBlockFullCube() {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TilePotentiometer();
    }

    protected static boolean canPlaceBlock(World worldIn, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        return worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, direction.func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return Potentiometer.canPlaceBlock(context.func_195991_k(), context.func_195995_a(), context.func_196000_l().func_176734_d()) ? (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l()) : (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.DOWN);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return Potentiometer.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d()), (Direction)((Direction)state.func_177229_b((Property)FACING)));
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.func_203425_a(newState.func_177230_c())) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TilePotentiometer && ((TilePotentiometer)tile).power.get() > 0) {
                this.updateNeighbors(state, worldIn, pos, (TilePotentiometer)tile);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    private void updateNeighbors(BlockState state, World world, BlockPos pos, TilePotentiometer tile) {
        world.func_195593_d(pos, (Block)this);
        world.func_195593_d(pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d()), (Block)this);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction enumfacing = (Direction)state.func_177229_b((Property)FACING);
        switch (enumfacing) {
            case EAST: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_WEST;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            case UP: {
                return AABB_UP;
            }
            case DOWN: {
                return AABB_DOWN;
            }
        }
        return AABB_NORTH;
    }
}

