/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import com.brandon3055.brandonscore.api.power.IOPStorageModifiable;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class StackModuleContext
extends ModuleContext {
    private final ItemStack stack;
    private final LivingEntity entity;
    private final EquipmentSlotType slot;
    private boolean inEquipModSlot = false;

    public StackModuleContext(ItemStack stack, LivingEntity entity, EquipmentSlotType slot) {
        this.stack = stack;
        this.entity = entity;
        this.slot = slot;
    }

    public StackModuleContext setInEquipModSlot(boolean inEquipModSlot) {
        this.inEquipModSlot = inEquipModSlot;
        return this;
    }

    @Override
    public IOPStorageModifiable getOpStorage() {
        LazyOptional optional = this.stack.getCapability(DECapabilities.OP_STORAGE);
        if (optional.isPresent()) {
            return (IOPStorageModifiable)optional.orElseThrow(IllegalStateException::new);
        }
        return null;
    }

    @Override
    public ModuleContext.Type getType() {
        return ModuleContext.Type.ITEM_STACK;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public IModularItem getItem() {
        return (IModularItem)this.stack.func_77973_b();
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    @Nullable
    public EquipmentSlotType getSlot() {
        return this.slot;
    }

    public boolean isEquipped() {
        return this.getItem().isEquipped(this.getStack(), this.getSlot(), this.inEquipModSlot);
    }
}

