/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleProvider;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ModuleItem<P extends ModuleData<P>>
extends Item
implements ModuleProvider<P> {
    @Deprecated
    private Module<P> module = null;
    private Supplier<Module<P>> moduleSupplier;

    public ModuleItem(Item.Properties properties, Supplier<Module<P>> moduleSupplier) {
        super(properties);
        this.moduleSupplier = moduleSupplier;
    }

    public ModuleItem(Item.Properties properties, Module<P> module) {
        super(properties);
        this.module = module;
    }

    public ModuleItem(Item.Properties properties) {
        super(properties);
    }

    public void setModule(Module<P> module) {
        this.module = module;
    }

    public static Module<?> getModule(ItemStack stack) {
        LazyOptional cap = stack.getCapability(DECapabilities.MODULE_CAPABILITY);
        if (!stack.func_190926_b() && cap.isPresent()) {
            return ((ModuleProvider)cap.orElseThrow(RuntimeException::new)).getModule();
        }
        return null;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == DECapabilities.MODULE_CAPABILITY) {
                    return LazyOptional.of(() -> ModuleItem.this).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    @Override
    public Module<P> getModule() {
        if (this.module == null) {
            this.module = this.moduleSupplier.get();
        }
        return this.module;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.getModule().addInformation(tooltip);
        ModuleEntity entity = this.getModule().createEntity();
        entity.readFromItemStack(stack, new StackModuleContext(stack, null, null));
        entity.addToolTip(tooltip);
        if (this.getModule().getType() == ModuleTypes.FLIGHT && EquipmentManager.equipModLoaded()) {
            tooltip.add((ITextComponent)new StringTextComponent("//Elytra does not currently work when chestpiece is in a curio slot."));
        }
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.getModule().getProperties().getTechLevel().getRarity();
    }
}

