/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.lib.InstallResult;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleItem;
import com.brandon3055.draconicevolution.inventory.ContainerModuleHost;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ModuleGrid {
    private int xPos = 0;
    private int yPos = 0;
    public ContainerModuleHost<?> container;
    private PlayerInventory player;
    private int cellSize = 16;
    private Runnable onGridChange;

    public ModuleGrid(ContainerModuleHost<?> container, PlayerInventory player) {
        this.container = container;
        this.player = player;
    }

    public void setOnGridChange(Runnable onGridChange) {
        this.onGridChange = onGridChange;
    }

    private void onGridChange() {
        if (this.onGridChange != null) {
            this.onGridChange.run();
        }
        this.container.onGridChange();
    }

    public void setPosition(int guiXPos, int guiYPos) {
        this.xPos = guiXPos;
        this.yPos = guiYPos;
    }

    public ModuleHost getModuleHost() {
        return this.container.getModuleHost();
    }

    public int getWidth() {
        return this.getModuleHost().getGridWidth();
    }

    public int getHeight() {
        return this.getModuleHost().getGridHeight();
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(int cellSize) {
        this.cellSize = cellSize;
    }

    public InstallResult cellClicked(GridPos pos, int button, ClickType clickType) {
        ItemStack stack = this.player.func_70445_o();
        Module<?> module = ModuleItem.getModule(stack);
        boolean holdingStack = !stack.func_190926_b();
        ModuleContext context = this.container.getModuleContext();
        if (holdingStack && module == null || !pos.isValidCell()) {
            return null;
        }
        if (clickType == ClickType.PICKUP) {
            if (holdingStack) {
                ModuleEntity entity = module.createEntity();
                entity.setPos(pos.gridX, pos.gridY);
                InstallResult result = this.checkInstall(entity);
                if (result.resultType == InstallResult.InstallResultType.YES) {
                    entity.readFromItemStack(stack, context);
                    this.getModuleHost().addModule(entity, context);
                    stack.func_190918_g(1);
                    this.onGridChange();
                    return null;
                }
                return result;
            }
            if (pos.hasEntity()) {
                ModuleEntity entity = pos.getEntity();
                ItemStack extracted = new ItemStack((IItemProvider)entity.getModule().getItem());
                entity.writeToItemStack(extracted, context);
                this.getModuleHost().removeModule(entity, context);
                this.player.func_70437_b(extracted);
                this.onGridChange();
            }
        } else if (clickType == ClickType.QUICK_MOVE) {
            if (pos.hasEntity()) {
                ModuleEntity entity = pos.getEntity();
                ItemStack extracted = new ItemStack((IItemProvider)entity.getModule().getItem());
                entity.writeToItemStack(extracted, context);
                if (this.player.func_70441_a(extracted)) {
                    this.getModuleHost().removeModule(entity, context);
                    this.onGridChange();
                }
            }
        } else if (clickType == ClickType.PICKUP_ALL && module != null) {
            for (ModuleEntity entity : ImmutableList.copyOf(this.getModuleHost().getModuleEntities())) {
                if (entity.module == module) {
                    ItemStack modStack = new ItemStack((IItemProvider)module.getItem());
                    entity.writeToItemStack(modStack, context);
                    if (Container.func_195929_a((ItemStack)stack, (ItemStack)modStack) && stack.func_190916_E() < stack.func_77976_d()) {
                        stack.func_190917_f(1);
                        this.getModuleHost().removeModule(entity, context);
                    }
                }
                this.onGridChange();
            }
        } else if (clickType == ClickType.CLONE && this.player.field_70458_d.field_71075_bZ.field_75098_d && this.player.func_70445_o().func_190926_b() && pos.hasEntity()) {
            ModuleEntity entity = pos.getEntity();
            ItemStack modStack = new ItemStack((IItemProvider)entity.module.getItem());
            entity.writeToItemStack(modStack, context);
            this.player.func_70437_b(modStack);
        }
        return null;
    }

    public boolean attemptInstall(ModuleEntity entity) {
        for (int y = 0; y < this.getWidth(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                entity.setPos(x, y);
                if (this.checkInstall((ModuleEntity)entity).resultType != InstallResult.InstallResultType.YES) continue;
                this.getModuleHost().addModule(entity, this.container.getModuleContext());
                this.onGridChange();
                return true;
            }
        }
        return false;
    }

    public InstallResult checkInstall(ModuleEntity entity) {
        ModuleHost host = this.getModuleHost();
        if (host.getHostTechLevel().index < entity.module.getModuleTechLevel().index) {
            return new InstallResult(InstallResult.InstallResultType.NO, entity.module, null, (ITextComponent)new TranslationTextComponent("modular_item.draconicevolution.cant_install.level_high"));
        }
        if (!host.isModuleSupported(entity)) {
            return new InstallResult(InstallResult.InstallResultType.NO, entity.module, null, (ITextComponent)new TranslationTextComponent("modular_item.draconicevolution.cant_install.not_supported"));
        }
        if (host.getModuleEntities().stream().anyMatch(entity::intersects)) {
            return new InstallResult(InstallResult.InstallResultType.NO, entity.module, null, (ITextComponent)new TranslationTextComponent("modular_item.draconicevolution.cant_install.wont_fit"));
        }
        if (entity.getMaxGridX() > host.getGridWidth() || entity.getMaxGridY() > this.getModuleHost().getGridHeight()) {
            return new InstallResult(InstallResult.InstallResultType.NO, entity.module, null, (ITextComponent)new TranslationTextComponent("modular_item.draconicevolution.cant_install.wont_fit"));
        }
        InstallResult result = ModuleHost.checkAddModule(host, entity.module);
        if (result.resultType == InstallResult.InstallResultType.YES || result.resultType == InstallResult.InstallResultType.OVERRIDE) {
            return new InstallResult(InstallResult.InstallResultType.YES, entity.module, null, null);
        }
        return result;
    }

    public GridPos getCell(int gridX, int gridY) {
        if (gridX < 0 || gridX >= this.getModuleHost().getGridWidth() || gridY < 0 || gridY >= this.getModuleHost().getGridHeight()) {
            return new GridPos(this);
        }
        return new GridPos(gridX, gridY, this);
    }

    public static class GridPos {
        private final int gridX;
        private final int gridY;
        private final ModuleGrid grid;
        private final ModuleEntity entity;

        GridPos(ModuleGrid grid) {
            this.grid = grid;
            this.gridY = -1;
            this.gridX = -1;
            this.entity = null;
        }

        public GridPos(int gridX, int gridY, ModuleGrid grid) {
            this.gridX = gridX;
            this.gridY = gridY;
            this.grid = grid;
            this.entity = grid.getModuleHost().getModuleEntities().stream().filter(module -> module.contains(gridX, gridY)).findFirst().orElse(null);
        }

        public boolean hasEntity() {
            return this.entity != null;
        }

        public ModuleEntity getEntity() {
            return this.entity;
        }

        public int getGridX() {
            return this.gridX;
        }

        public int getGridY() {
            return this.gridY;
        }

        public boolean isActualEntityPos() {
            return this.hasEntity() && this.entity.checkPos(this.gridX, this.gridY);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridPos gridPos = (GridPos)o;
            return this.gridX == gridPos.gridX && this.gridY == gridPos.gridY;
        }

        public int hashCode() {
            return Objects.hash(this.gridX, this.gridY);
        }

        public boolean isValidCell() {
            return this.gridX != -1 && this.gridY != -1;
        }
    }
}

