/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.data;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ModuleProperties<T extends ModuleData<T>> {
    private final TechLevel techLevel;
    private int width;
    private int height;
    private T data;
    private Function<Module<T>, T> dataGenerator;

    public ModuleProperties(TechLevel techLevel, Function<Module<T>, T> dataGenerator) {
        this(techLevel, -1, -1, dataGenerator);
    }

    public ModuleProperties(TechLevel techLevel, int width, int height, Function<Module<T>, T> dataGenerator) {
        this.techLevel = techLevel;
        this.width = width;
        this.height = height;
        this.dataGenerator = dataGenerator;
    }

    public void reloadData(Module<T> module) {
        this.data = (ModuleData)this.dataGenerator.apply(module);
    }

    public T getData() {
        return this.data;
    }

    public int getWidth() {
        if (this.width == -1) {
            throw new IllegalStateException("Module dimensions have not been set! " + this.getData());
        }
        return this.width;
    }

    public int getHeight() {
        if (this.height == -1) {
            throw new IllegalStateException("Module dimensions have not been set! " + this.getData());
        }
        return this.height;
    }

    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    public void loadDefaults(ModuleType<T> moduleType) {
        if (this.width == -1 && moduleType.getDefaultWidth() != -1) {
            this.width = moduleType.getDefaultWidth();
        }
        if (this.height == -1 && moduleType.getDefaultHeight() != -1) {
            this.height = moduleType.getDefaultHeight();
        }
    }

    public void addStats(List<ITextComponent> toolTip, Module<?> module) {
        toolTip.add((ITextComponent)new TranslationTextComponent("module.draconicevolution.module_type").func_240699_a_(TextFormatting.GRAY).func_240702_b_(": ").func_230529_a_((ITextComponent)module.getType().getDisplayName().func_240699_a_(this.techLevel.getTextColour())));
        toolTip.add((ITextComponent)new TranslationTextComponent("module.draconicevolution.grid_size").func_240699_a_(TextFormatting.GRAY).func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent(this.getWidth() + "x" + this.getHeight()).func_240699_a_(TextFormatting.DARK_GREEN)));
        HashMap<ITextComponent, ITextComponent> map = new HashMap<ITextComponent, ITextComponent>();
        this.getData().addInformation(map, null, true);
        map.forEach((name, value) -> {
            if (value == null) {
                toolTip.add((ITextComponent)name.func_230531_f_().func_240699_a_(TextFormatting.GRAY));
            } else {
                toolTip.add((ITextComponent)name.func_230531_f_().func_240699_a_(TextFormatting.GRAY).func_240702_b_(": ").func_240702_b_(value.func_230531_f_().func_240699_a_(TextFormatting.DARK_GREEN).getString().replace("\n", " ")));
            }
        });
    }
}

