/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.data;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class FlightData
implements ModuleData<FlightData> {
    private final boolean elytra;
    private final boolean creative;
    private final double elytraSpeed;

    public FlightData(boolean elytra, boolean creative, double elytraSpeed) {
        this.elytra = elytra;
        this.creative = creative;
        this.elytraSpeed = elytraSpeed;
    }

    public boolean elytra() {
        return this.elytra;
    }

    public boolean creative() {
        return this.creative;
    }

    public double getElytraSpeed() {
        return this.elytraSpeed;
    }

    @Override
    public FlightData combine(FlightData other) {
        return other;
    }

    @Override
    public void addInformation(Map<ITextComponent, ITextComponent> map, ModuleContext context, boolean stack) {
        map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.flight.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.flight." + this.elytra + "." + this.creative));
        if (this.elytra && this.elytraSpeed > 0.0) {
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.flight.boost.name"), (ITextComponent)new StringTextComponent((int)(this.elytraSpeed * 100.0) + "%"));
        }
        if (this.elytra && !DEConfig.enableElytraFlight) {
            map.put((ITextComponent)new StringTextComponent("Elytra Flight").func_240699_a_(TextFormatting.RED), (ITextComponent)new StringTextComponent("Disabled by server").func_240699_a_(TextFormatting.RED));
        }
        if (this.creative && !DEConfig.enableCreativeFlight) {
            map.put((ITextComponent)new StringTextComponent("Creative Flight").func_240699_a_(TextFormatting.RED), (ITextComponent)new StringTextComponent("Disabled by server").func_240699_a_(TextFormatting.RED));
        }
    }
}

