/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.data.manager.AbstractDataManager;

public class SimpleDataManager<T>
extends AbstractDataManager<T, JsonElement> {
    public SimpleDataManager(Class<T> contentType, String folder, Function<ResourceLocation, T> defaultValueFactory, BiConsumer<T, ResourceLocation> idSetter) {
        super(contentType, folder, defaultValueFactory, idSetter);
    }

    protected Map<ResourceLocation, JsonElement> prepare(IResourceManager resourceManager, IProfiler profilerIn) {
        HashMap map = Maps.newHashMap();
        int i = this.folder.length() + 1;
        for (ResourceLocation resourcelocation : resourceManager.func_199003_a(this.folder, file -> file.endsWith(".json"))) {
            String path = resourcelocation.func_110623_a();
            ResourceLocation resourceId = new ResourceLocation(resourcelocation.func_110624_b(), path.substring(i, path.length() - 5));
            try {
                IResource resource = resourceManager.func_199002_a(resourcelocation);
                Throwable throwable = null;
                try {
                    InputStream inputstream = resource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                        Throwable throwable3 = null;
                        try {
                            JsonElement jsonelement = (JsonElement)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonElement.class);
                            if (jsonelement != null) {
                                map.put(resourceId, jsonelement);
                                continue;
                            }
                            DataPackAnvilApi.LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourceId, (Object)resourcelocation);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (inputstream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputstream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        inputstream.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                DataPackAnvilApi.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourceId, (Object)resourcelocation, (Object)e);
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        HashMap map = Maps.newHashMap();
        Object serializer = DataPackAnvil.WRAPPER.getSerializer(this.id);
        objects.forEach((loc, jsonObject) -> {
            Object value = serializer.read((JsonElement)jsonObject);
            this.idSetter.accept(value, loc);
            map.put(loc, value);
        });
        this.setData(map);
    }
}

