/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.annotation;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.ReflectionHelper;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.annotation.DataHolder;

public class DPAnvilAnnotationProcessor {
    private static final Type DATA_HOLDER = Type.getType(DataHolder.class);
    private Map<Field, ResourceLocation> dataHolders;

    public void setup() {
        ImmutableMap.Builder dataHoldersBuilder = ImmutableMap.builder();
        ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> DATA_HOLDER.equals((Object)a.getAnnotationType())).map(ModFileScanData.AnnotationData::getClassType).distinct().map(this::getClass).filter(Objects::nonNull).map(Class::getDeclaredFields).flatMap(Stream::of).filter(field -> field.isAnnotationPresent(DataHolder.class)).forEach(field -> {
            ReflectionHelper.setAccesible(field);
            dataHoldersBuilder.put(field, (Object)new ResourceLocation(field.getAnnotation(DataHolder.class).value()));
        });
        this.dataHolders = dataHoldersBuilder.build();
    }

    private <T> Class<T> getClass(Type type) {
        try {
            return Class.forName(type.getClassName(), false, DPAnvilAnnotationProcessor.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void applyDataHolder() {
        this.dataHolders.forEach((field, id) -> {
            Object manager = DataPackAnvil.WRAPPER.getManager(field.getType());
            if (manager != null) {
                try {
                    field.set(null, manager.get((ResourceLocation)id));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    DataPackAnvilApi.LOGGER.error(() -> "Error while setting field " + field.getName(), (Throwable)e);
                }
            } else {
                DataPackAnvilApi.LOGGER.warn("Couldn't find DataManager for class {} of field {}", (Object)field.getType().getName(), (Object)field.getName());
            }
        });
    }
}

