/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tile;

import edivad.dimstorage.Main;
import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.Frequency;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class TileFrequencyOwner
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public boolean locked = false;
    private Frequency frequency = new Frequency();
    private int changeCount;

    public TileFrequencyOwner(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void setFrequency(Frequency frequency) {
        this.frequency.set(frequency);
        this.func_70296_d();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public Frequency getFrequency() {
        return this.frequency.copy();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void swapOwner() {
        if (this.frequency.hasOwner()) {
            this.setFrequency(this.getFrequency().setPublic());
        } else {
            this.setFrequency(this.getFrequency().setOwner(Main.proxy.getClientPlayer()));
        }
    }

    public void swapLocked() {
        this.locked = !this.locked;
        this.func_70296_d();
    }

    public boolean canAccess(PlayerEntity player) {
        return this.frequency.canAccess(player);
    }

    public void func_73660_a() {
        if (this.getStorage().getChangeCount() > this.changeCount) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
            this.changeCount = this.getStorage().getChangeCount();
        }
    }

    public abstract AbstractDimStorage getStorage();

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.frequency.set(new Frequency(tag.func_74775_l("Frequency")));
        this.locked = tag.func_74767_n("locked");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Frequency", (INBT)this.frequency.serializeNBT());
        tag.func_74757_a("locked", this.locked);
        return tag;
    }

    public ActionResultType activate(PlayerEntity player, World worldIn, BlockPos pos, Hand hand) {
        if (this.canAccess(player)) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> buf.func_179255_a(this.func_174877_v()).writeBoolean(false));
        } else {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Access Denied!"), false);
        }
        return ActionResultType.SUCCESS;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_218657_a("Frequency", (INBT)this.frequency.serializeNBT());
        tag.func_74757_a("locked", this.locked);
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.setFrequency(new Frequency(tag.func_74775_l("Frequency")));
        this.locked = tag.func_74767_n("locked");
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }
}

