/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.packet;

import edivad.dimstorage.Main;
import edivad.dimstorage.network.packet.UpdateDimBase;
import edivad.dimstorage.tile.TileEntityDimTank;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class UpdateDimTank
extends UpdateDimBase {
    protected boolean autoEject;

    public UpdateDimTank(PacketBuffer buf) {
        super(buf);
        this.autoEject = buf.readBoolean();
    }

    public UpdateDimTank(TileEntityDimTank tile) {
        super(tile);
        this.autoEject = tile.autoEject;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.autoEject);
    }

    @Override
    public void customHandle(World world, ServerPlayerEntity player) {
        TileEntity tile = world.func_175625_s(this.pos);
        if (!(tile instanceof TileEntityDimTank)) {
            Main.logger.error("Wrong type of tile entity (expected TileEntityDimTank)!");
            return;
        }
        TileEntityDimTank tank = (TileEntityDimTank)tile;
        tank.setFrequency(this.freq);
        tank.locked = this.locked;
        tank.autoEject = this.autoEject;
        tank.func_70296_d();
        world.func_184138_a(this.pos, tank.func_195044_w(), tank.func_195044_w(), 3);
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)tank, buf -> buf.func_179255_a(this.pos).writeBoolean(true));
    }
}

