/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.packet;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.tile.TileFrequencyOwner;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class UpdateDimBase {
    protected BlockPos pos;
    protected Frequency freq;
    protected boolean locked;

    public UpdateDimBase(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.freq = Frequency.readFromPacket(buf);
        this.locked = buf.readBoolean();
    }

    public UpdateDimBase(TileFrequencyOwner tile) {
        this.pos = tile.func_174877_v();
        this.freq = tile.getFrequency();
        this.locked = tile.locked;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        this.freq.writeToPacket(buf);
        buf.writeBoolean(this.locked);
    }

    public abstract void customHandle(World var1, ServerPlayerEntity var2);

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            if (world.func_195588_v(this.pos)) {
                this.customHandle(world, player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

