/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.items;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.container.ContainerDimTablet;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.setup.ModSetup;
import edivad.dimstorage.storage.DimChestStorage;
import edivad.dimstorage.tile.TileEntityDimChest;
import edivad.dimstorage.tools.Config;
import edivad.dimstorage.tools.CustomTranslate;
import edivad.dimstorage.tools.utils.InventoryUtils;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.wrapper.InvWrapper;

public class DimTablet
extends Item
implements INamedContainerProvider {
    public DimTablet() {
        super(new Item.Properties().func_200916_a(ModSetup.dimStorageTab).func_200917_a(1));
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        if (!world.field_72995_K) {
            ItemStack device = player.func_184586_b(context.func_221531_n());
            TileEntity tile = world.func_175625_s(pos);
            if (player.func_213453_ef()) {
                if (tile instanceof TileEntityDimChest) {
                    TileEntityDimChest dimChest = (TileEntityDimChest)tile;
                    if (dimChest.canAccess(player)) {
                        CompoundNBT tag = new CompoundNBT();
                        tag.func_218657_a("frequency", (INBT)dimChest.getFrequency().serializeNBT());
                        tag.func_74757_a("bound", true);
                        tag.func_74757_a("autocollect", false);
                        device.func_77982_d(tag);
                        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Linked to chest"), false);
                        return ActionResultType.SUCCESS;
                    }
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Access Denied!"), false);
                } else {
                    stack.func_77978_p().func_74757_a("autocollect", !stack.func_77978_p().func_74767_n("autocollect"));
                    if (stack.func_77978_p().func_74767_n("autocollect")) {
                        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Enabled autocollect"), false);
                    } else {
                        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Disabled autocollect"), false);
                    }
                }
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && hand.compareTo((Enum)Hand.MAIN_HAND) == 0) {
            if (player.func_213453_ef()) {
                return super.func_77659_a(world, player, hand);
            }
            if (!stack.func_196082_o().func_74767_n("bound")) {
                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Dimensional Tablet not connected to any DimChest"), false);
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            Frequency f = new Frequency(stack.func_196082_o().func_74775_l("frequency"));
            if (!f.canAccess(player)) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K && stack.func_196082_o().func_74767_n("autocollect") && stack.func_196082_o().func_74767_n("bound") && entityIn instanceof PlayerEntity) {
            PlayerEntity pe = (PlayerEntity)entityIn;
            Frequency f = new Frequency(stack.func_196082_o().func_74775_l("frequency"));
            InvWrapper chestInventory = new InvWrapper((IInventory)this.getStorage(worldIn, f));
            for (int i = 0; i < pe.field_71071_by.func_70302_i_(); ++i) {
                Item item = pe.field_71071_by.func_70301_a(i).func_77973_b();
                if (!((List)Config.DIMTABLET_LIST.get()).contains(item.getRegistryName().toString())) continue;
                InventoryUtils.mergeItemStack(pe.field_71071_by.func_70301_a(i), 0, this.getStorage(worldIn, f).func_70302_i_(), chestInventory);
            }
        }
    }

    private DimChestStorage getStorage(World world, Frequency frequency) {
        return (DimChestStorage)DimStorageManager.instance(world.field_72995_K).getStorage(frequency, "item");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (worldIn != null) {
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("bound")) {
                tooltip.add((ITextComponent)CustomTranslate.translateToLocal("message.dimstorage.adviceToLink"));
                return;
            }
            CompoundNBT tag = stack.func_77978_p();
            if (Screen.func_231173_s_()) {
                Frequency f = new Frequency(tag.func_74775_l("frequency"));
                tooltip.add((ITextComponent)new TranslationTextComponent("gui.dimstorage.frequency").func_240702_b_(" " + f.getChannel()).func_240699_a_(TextFormatting.GRAY));
                if (f.hasOwner()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("gui.dimstorage.owner").func_240702_b_(" " + f.getOwner()).func_240699_a_(TextFormatting.GRAY));
                }
                String yes = new TranslationTextComponent("gui.dimstorage.yes").getString();
                String no = new TranslationTextComponent("gui.dimstorage.no").getString();
                tooltip.add((ITextComponent)new TranslationTextComponent("gui.dimstorage.collecting").func_240702_b_(": " + (tag.func_74767_n("autocollect") ? yes : no)).func_240699_a_(TextFormatting.GRAY));
            } else {
                tooltip.add((ITextComponent)CustomTranslate.translateToLocal("message.dimstorage.holdShift"));
            }
            tooltip.add((ITextComponent)CustomTranslate.translateToLocal("message.dimstorage.changeAutoCollect"));
        }
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerDimTablet(id, playerInventory, playerEntity.field_70170_p);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_77658_a());
    }
}

