/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.feature.gateway.schematic;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.function.BiPredicate;
import net.minecraft.class_2338;
import net.minecraft.class_2507;
import net.minecraft.class_5281;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.BlockPlacementType;
import org.dimdev.dimdoors.pockets.TemplateUtils;
import org.dimdev.dimdoors.util.schematic.Schematic;
import org.dimdev.dimdoors.util.schematic.SchematicPlacer;
import org.dimdev.dimdoors.world.feature.gateway.Gateway;

public abstract class SchematicGateway
implements Gateway,
BiPredicate<class_5281, class_2338> {
    private Schematic schematic;
    private final String id;
    public static final BiMap<String, SchematicGateway> ID_SCHEMATIC_MAP = HashBiMap.create();
    private boolean replaced;

    public SchematicGateway(String id) {
        ID_SCHEMATIC_MAP.putIfAbsent((Object)id, (Object)this);
        this.id = id;
    }

    public void init() {
        String schematicJarDirectory = "/data/dimdoors/gateways/";
        try (InputStream stream = DimensionalDoors.class.getResourceAsStream(schematicJarDirectory + this.id + ".schem");){
            if (stream == null) {
                throw new RuntimeException("Schematic '" + this.id + "' was not found in the jar.");
            }
            try {
                this.schematic = Schematic.fromNbt(class_2507.method_10629((InputStream)stream));
            }
            catch (IOException ex) {
                throw new RuntimeException("Schematic file for " + this.id + " could not be read as a valid schematic NBT file.", ex);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public final void generate(class_5281 world, class_2338 pos) {
        if (DimensionalDoors.getConfig().getWorldConfig().gatewayDimBlacklist.contains(world.method_8410().method_27983().method_29177().toString())) {
            return;
        }
        if (!this.replaced) {
            TemplateUtils.replacePlaceholders(this.schematic, world);
            this.replaced = true;
        }
        SchematicPlacer.place(this.schematic, world, pos, BlockPlacementType.SECTION_NO_UPDATE_QUEUE_BLOCK_ENTITY);
        this.generateRandomBits(world, pos);
    }

    protected void generateRandomBits(class_5281 world, class_2338 pos) {
    }
}

