/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.rift.target.Target;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RGBA;
import org.dimdev.dimdoors.rift.targets.DungeonTarget;
import org.dimdev.dimdoors.rift.targets.EscapeTarget;
import org.dimdev.dimdoors.rift.targets.GlobalReference;
import org.dimdev.dimdoors.rift.targets.IdMarker;
import org.dimdev.dimdoors.rift.targets.LimboTarget;
import org.dimdev.dimdoors.rift.targets.LocalReference;
import org.dimdev.dimdoors.rift.targets.PocketEntranceMarker;
import org.dimdev.dimdoors.rift.targets.PocketExitMarker;
import org.dimdev.dimdoors.rift.targets.PrivatePocketExitTarget;
import org.dimdev.dimdoors.rift.targets.PrivatePocketTarget;
import org.dimdev.dimdoors.rift.targets.PublicPocketTarget;
import org.dimdev.dimdoors.rift.targets.RandomTarget;
import org.dimdev.dimdoors.rift.targets.RelativeReference;
import org.dimdev.dimdoors.rift.targets.UnstableTarget;

public abstract class VirtualTarget
implements Target {
    public static final Registrar<VirtualTargetType<?>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("virtual_type"), (Object[])new VirtualTargetType[0]).build();
    public static final RGBA COLOR = new RGBA(1.0f, 0.0f, 0.0f, 1.0f);
    protected Location location;

    public static VirtualTarget fromNbt(class_2487 nbt) {
        class_2960 id = new class_2960(nbt.method_10558("type"));
        return Objects.requireNonNull((VirtualTargetType)REGISTRY.get(id), "Unknown virtual target type " + String.valueOf(id)).fromNbt(nbt);
    }

    public static class_2487 toNbt(VirtualTarget virtualTarget) {
        class_2960 id = REGISTRY.getId(virtualTarget.getType());
        String type = id.toString();
        class_2487 nbt = virtualTarget.getType().toNbt(virtualTarget);
        nbt.method_10582("type", type);
        return nbt;
    }

    public void register() {
    }

    public void unregister() {
    }

    public abstract VirtualTargetType<? extends VirtualTarget> getType();

    public boolean shouldInvalidate(Location riftDeleted) {
        return false;
    }

    public RGBA getColor() {
        return this.getType().getColor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualTarget that = (VirtualTarget)o;
        return Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.location);
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean isDummy() {
        return false;
    }

    public abstract VirtualTarget copy();

    public static interface VirtualTargetType<T extends VirtualTarget> {
        public static final RegistrySupplier<VirtualTargetType<RandomTarget>> AVAILABLE_LINK = VirtualTargetType.register("dimdoors:available_link", RandomTarget::fromNbt, RandomTarget::toNbt, COLOR);
        public static final RegistrySupplier<VirtualTargetType<DungeonTarget>> DUNGEON = VirtualTargetType.register("dimdoors:dungeon", DungeonTarget::fromNbt, DungeonTarget::toNbt, COLOR);
        public static final RegistrySupplier<VirtualTargetType<EscapeTarget>> ESCAPE = VirtualTargetType.register("dimdoors:escape", EscapeTarget::fromNbt, EscapeTarget::toNbt, COLOR);
        public static final RegistrySupplier<VirtualTargetType<GlobalReference>> GLOBAL = VirtualTargetType.register("dimdoors:global", GlobalReference::fromNbt, GlobalReference::toNbt, COLOR);
        public static final RegistrySupplier<VirtualTargetType<LimboTarget>> LIMBO = VirtualTargetType.register("dimdoors:limbo", a -> LimboTarget.INSTANCE, a -> new class_2487(), COLOR);
        public static final RegistrySupplier<VirtualTargetType<LocalReference>> LOCAL = VirtualTargetType.register("dimdoors:local", LocalReference::fromNbt, LocalReference::toNbt, COLOR);
        public static final RegistrySupplier<VirtualTargetType<PublicPocketTarget>> PUBLIC_POCKET = VirtualTargetType.register("dimdoors:public_pocket", PublicPocketTarget::fromNbt, PublicPocketTarget::toNbt, COLOR);
        public static final RegistrySupplier<VirtualTargetType<PocketEntranceMarker>> POCKET_ENTRANCE = VirtualTargetType.register("dimdoors:pocket_entrance", PocketEntranceMarker::fromNbt, PocketEntranceMarker::toNbt, COLOR);
        public static final RegistrySupplier<VirtualTargetType<PocketExitMarker>> POCKET_EXIT = VirtualTargetType.register("dimdoors:pocket_exit", a -> new PocketExitMarker(), a -> new class_2487(), COLOR);
        public static final RegistrySupplier<VirtualTargetType<PrivatePocketTarget>> PRIVATE = VirtualTargetType.register("dimdoors:private", a -> new PrivatePocketTarget(), a -> new class_2487(), PrivatePocketExitTarget.COLOR);
        public static final RegistrySupplier<VirtualTargetType<PrivatePocketExitTarget>> PRIVATE_POCKET_EXIT = VirtualTargetType.register("dimdoors:private_pocket_exit", a -> new PrivatePocketExitTarget(), a -> new class_2487(), PrivatePocketExitTarget.COLOR);
        public static final RegistrySupplier<VirtualTargetType<RelativeReference>> RELATIVE = VirtualTargetType.register("dimdoors:relative", RelativeReference::fromNbt, RelativeReference::toNbt, COLOR);
        public static final RegistrySupplier<VirtualTargetType<IdMarker>> ID_MARKER = VirtualTargetType.register("dimdoors:id_marker", IdMarker::fromNbt, IdMarker::toNbt, COLOR);
        public static final RegistrySupplier<VirtualTargetType<UnstableTarget>> UNSTABLE = VirtualTargetType.register("dimdoors:unstable", nbt -> new UnstableTarget(), t -> new class_2487(), COLOR);
        public static final RegistrySupplier<VirtualTargetType<NoneTarget>> NONE = VirtualTargetType.register("dimdoors:none", nbt -> NoneTarget.INSTANCE, i -> new class_2487(), COLOR);
        public static final Map<VirtualTargetType<?>, String> TRANSLATION_KEYS = new Object2ObjectArrayMap();

        public T fromNbt(class_2487 var1);

        public class_2487 toNbt(VirtualTarget var1);

        public RGBA getColor();

        default public class_2960 getId() {
            return REGISTRY.getId((Object)this);
        }

        default public String getTranslationKey() {
            return TRANSLATION_KEYS.computeIfAbsent(this, t -> {
                class_2960 id = t.getId();
                return "dimdoors.virtualTarget." + id.method_12836() + "." + id.method_12832();
            });
        }

        public static void register() {
        }

        public static <T extends VirtualTarget> RegistrySupplier<VirtualTargetType<T>> register(String id, final Function<class_2487, T> fromNbt, final Function<T, class_2487> toNbt, final RGBA color) {
            return REGISTRY.register(new class_2960(id), () -> new VirtualTargetType<T>(){

                @Override
                public T fromNbt(class_2487 nbt) {
                    return (VirtualTarget)fromNbt.apply(nbt);
                }

                @Override
                public class_2487 toNbt(VirtualTarget virtualType) {
                    return (class_2487)toNbt.apply(virtualType);
                }

                @Override
                public RGBA getColor() {
                    return color;
                }
            });
        }
    }

    public static class NoneTarget
    extends VirtualTarget {
        public static final NoneTarget INSTANCE = new NoneTarget();

        private NoneTarget() {
        }

        @Override
        public VirtualTargetType<? extends VirtualTarget> getType() {
            return (VirtualTargetType)VirtualTargetType.NONE.get();
        }

        @Override
        public boolean equals(Object o) {
            return o == INSTANCE;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(INSTANCE);
        }

        @Override
        public VirtualTarget copy() {
            return INSTANCE;
        }

        public String toString() {
            return "[none]";
        }
    }
}

