/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2379;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import org.dimdev.dimdoors.api.rift.target.DefaultTargets;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.rift.target.FluidTarget;
import org.dimdev.dimdoors.api.rift.target.ItemTarget;
import org.dimdev.dimdoors.api.rift.target.RedstoneTarget;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.TeleportUtil;

public final class Targets {
    public static final Class<EntityTarget> ENTITY = EntityTarget.class;
    public static final Class<ItemTarget> ITEM = ItemTarget.class;
    public static final Class<FluidTarget> FLUID = FluidTarget.class;
    public static final Class<RedstoneTarget> REDSTONE = RedstoneTarget.class;

    public static void registerDefaultTargets() {
        DefaultTargets.registerDefaultTarget(ENTITY, new EntityTarget(){

            @Override
            public boolean receiveEntity(class_1297 entity, class_243 relativePos, class_2379 relativeRotation, class_243 relativeVelocity, Location location) {
                if (location != null) {
                    TeleportUtil.teleport(entity, (class_1937)location.getWorld(), class_243.method_26410((class_2382)location.pos, (double)0.0), relativeRotation, relativeVelocity);
                    return true;
                }
                EntityUtils.chat(entity, (class_2561)class_2561.method_43471((String)"rifts.unlinked2"));
                return false;
            }
        });
        DefaultTargets.registerDefaultTarget(ITEM, stack -> false);
        DefaultTargets.registerDefaultTarget(FLUID, new FluidTarget(){

            @Override
            public boolean addFluidFlow(class_2350 relativeFacing, class_3611 fluid, int level) {
                return false;
            }

            @Override
            public void subtractFluidFlow(class_2350 relativeFacing, class_3611 fluid, int level) {
                throw new RuntimeException("Subtracted fluid flow that was never accepted");
            }
        });
        DefaultTargets.registerDefaultTarget(REDSTONE, new RedstoneTarget(){

            @Override
            public boolean addRedstonePower(class_2350 relativeFacing, int strength) {
                return false;
            }

            @Override
            public void subtractRedstonePower(class_2350 relativeFacing, int strength) {
                throw new RuntimeException("Subtracted redstone that was never accepted");
            }
        });
    }
}

