/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import java.util.Set;
import net.minecraft.class_2382;
import org.dimdev.dimdoors.api.rift.target.Target;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RGBA;
import org.dimdev.dimdoors.rift.targets.GlobalReference;
import org.dimdev.dimdoors.rift.targets.LocalReference;
import org.dimdev.dimdoors.rift.targets.LocationProvider;
import org.dimdev.dimdoors.rift.targets.RelativeReference;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;

public abstract class RiftReference
extends VirtualTarget
implements LocationProvider {
    public static RiftReference tryMakeLocal(Location from, Location to) {
        if (from.world != to.world) {
            return new GlobalReference(to);
        }
        return new LocalReference(to.pos);
    }

    @Override
    public Location getLocation() {
        return this.getReferencedLocation();
    }

    public static RiftReference tryMakeRelative(Location from, Location to) {
        if (from.world != to.world) {
            return new GlobalReference(to);
        }
        return new RelativeReference(new class_2382(to.getX() - from.getX(), to.getY() - from.getY(), to.getZ() - from.getZ()));
    }

    public abstract Location getReferencedLocation();

    @Override
    public Target receiveOther() {
        return (Target)this.getReferencedLocation().getBlockEntity();
    }

    @Override
    public void register() {
        DimensionalRegistry.getRiftRegistry().addLink(this.location, this.getReferencedLocation());
    }

    @Override
    public void unregister() {
        DimensionalRegistry.getRiftRegistry().removeLink(this.location, this.getReferencedLocation());
    }

    @Override
    public boolean shouldInvalidate(Location deletedRift) {
        return deletedRift.equals(this.getReferencedLocation());
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public RGBA getColor() {
        Set<Location> otherRiftTargets;
        Location target = this.getReferencedLocation();
        if (target != null && DimensionalRegistry.getRiftRegistry().isRiftAt(target) && (otherRiftTargets = DimensionalRegistry.getRiftRegistry().getTargets(target)).size() == 1 && otherRiftTargets.contains(this.location)) {
            return new RGBA(0.0f, 1.0f, 0.0f, 1.0f);
        }
        return new RGBA(1.0f, 0.0f, 0.0f, 1.0f);
    }
}

