/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.pockets.PocketGenerator;
import org.dimdev.dimdoors.rift.targets.GlobalReference;
import org.dimdev.dimdoors.rift.targets.RestoringTarget;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class PublicPocketTarget
extends RestoringTarget {
    private VirtualTarget wrappedDestination = null;

    private PublicPocketTarget(VirtualTarget wrappedDestination) {
        this.wrappedDestination = wrappedDestination;
    }

    public PublicPocketTarget() {
    }

    @Override
    protected VirtualTarget getTarget() {
        return this.wrappedDestination;
    }

    @Override
    protected void setTarget(VirtualTarget target) {
        this.wrappedDestination = target;
    }

    @Override
    public Location makeLinkTarget() {
        VirtualLocation riftVirtualLocation = VirtualLocation.fromLocation(this.location);
        int depth = riftVirtualLocation.getDepth() + 1;
        VirtualLocation newVirtualLocation = new VirtualLocation(riftVirtualLocation.getWorld(), riftVirtualLocation.getX(), riftVirtualLocation.getZ(), depth);
        Pocket pocket = PocketGenerator.generatePublicPocketV2(newVirtualLocation, new GlobalReference(this.location), null);
        return DimensionalRegistry.getRiftRegistry().getPocketEntrance(pocket);
    }

    @Override
    public VirtualTarget.VirtualTargetType<? extends VirtualTarget> getType() {
        return (VirtualTarget.VirtualTargetType)VirtualTarget.VirtualTargetType.PUBLIC_POCKET.get();
    }

    @Override
    public VirtualTarget copy() {
        return new PublicPocketTarget(this.wrappedDestination);
    }

    public static class_2487 toNbt(PublicPocketTarget target) {
        class_2487 nbt = new class_2487();
        if (target.wrappedDestination != null) {
            nbt.method_10566("wrappedDestination", (class_2520)VirtualTarget.toNbt(target.wrappedDestination));
        }
        return nbt;
    }

    public static PublicPocketTarget fromNbt(class_2487 nbt) {
        PublicPocketTarget target = new PublicPocketTarget();
        if (nbt.method_10545("wrappedDestination")) {
            target.wrappedDestination = VirtualTarget.fromNbt(nbt.method_10562("wrappedDestination"));
        }
        return target;
    }
}

