/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.dimdev.dimdoors.block.entity.TesselatingLoomBlockEntity;
import org.dimdev.dimdoors.recipe.ModRecipeSerializers;
import org.dimdev.dimdoors.recipe.ModRecipeTypes;
import org.dimdev.dimdoors.recipe.TesselatingRecipe;
import org.jetbrains.annotations.NotNull;

public class ShapedTesselatingRecipe
implements TesselatingRecipe {
    private final int width;
    final int height;
    final class_2371<class_1856> recipeItems;
    final class_1799 result;
    private final class_2960 id;
    final String group;
    final boolean showNotification;
    private final int weavingTime;

    public ShapedTesselatingRecipe(class_2960 id, String group, int width, int height, class_2371<class_1856> recipeItems, class_1799 result, int weavingTime, boolean showNotification) {
        this.id = id;
        this.group = group;
        this.width = width;
        this.height = height;
        this.recipeItems = recipeItems;
        this.result = result;
        this.weavingTime = weavingTime;
        this.showNotification = showNotification;
    }

    public ShapedTesselatingRecipe(class_2960 id, String group, int width, int height, class_2371<class_1856> recipeItems, class_1799 result, int weavingTime) {
        this(id, group, width, height, recipeItems, result, weavingTime, true);
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)ModRecipeSerializers.SHAPED_TESSELATING.get();
    }

    @NotNull
    public String method_8112() {
        return this.group;
    }

    @NotNull
    public class_3956<?> method_17716() {
        return (class_3956)ModRecipeTypes.SHAPED_TESSELATING.get();
    }

    @NotNull
    public class_1799 method_8110(@NotNull class_5455 registryAccess) {
        return this.result;
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.recipeItems;
    }

    public boolean method_49188() {
        return this.showNotification;
    }

    public boolean method_8113(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    @Override
    public boolean matches(TesselatingLoomBlockEntity inv, class_1937 level) {
        for (int i = 0; i <= 3 - this.width; ++i) {
            for (int j = 0; j <= 3 - this.height; ++j) {
                if (this.matches(inv, i, j, true)) {
                    return true;
                }
                if (!this.matches(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(TesselatingLoomBlockEntity craftingInventory, int width, int height, boolean mirrored) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int k = x - width;
                int l = y - height;
                class_1856 ingredient = class_1856.field_9017;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    class_1856 class_18562 = ingredient = mirrored ? (class_1856)this.recipeItems.get(this.width - k - 1 + l * this.width) : (class_1856)this.recipeItems.get(k + l * this.width);
                }
                if (ingredient.method_8093(craftingInventory.method_5438(x + y * 3))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public class_2371<class_1799> getRemainingItems(TesselatingLoomBlockEntity container) {
        class_2371 nonNullList = class_2371.method_10213((int)container.method_5439(), (Object)class_1799.field_8037);
        for (int i = 1; i < nonNullList.size(); ++i) {
            class_1792 item = container.method_5438(i).method_7909();
            if (!item.method_7857()) continue;
            nonNullList.set(i, (Object)new class_1799((class_1935)item.method_7858()));
        }
        return nonNullList;
    }

    @NotNull
    public class_1799 assemble(@NotNull TesselatingLoomBlockEntity container, @NotNull class_5455 registryAccess) {
        return this.method_8110(registryAccess).method_7972();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static class_2371<class_1856> dissolvePattern(String[] pattern, Map<String, class_1856> keys, int patternWidth, int patternHeight) {
        class_2371 nonNullList = class_2371.method_10213((int)(patternWidth * patternHeight), (Object)class_1856.field_9017);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                class_1856 ingredient = keys.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                nonNullList.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(set));
        }
        return nonNullList;
    }

    @VisibleForTesting
    public static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < toShrink.length; ++m) {
            String string = toShrink[m];
            i = Math.min(i, ShapedTesselatingRecipe.firstNonSpace(string));
            int n = ShapedTesselatingRecipe.lastNonSpace(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] strings = new String[toShrink.length - l - k];
        for (int o = 0; o < strings.length; ++o) {
            strings[o] = toShrink[o + k].substring(i, j + 1);
        }
        return strings;
    }

    public boolean method_31584() {
        class_2371<class_1856> nonNullList = this.method_8117();
        return nonNullList.isEmpty() || nonNullList.stream().filter(ingredient -> !ingredient.method_8103()).anyMatch(ingredient -> ingredient.method_8105().length == 0);
    }

    private static int firstNonSpace(String entry) {
        int i;
        for (i = 0; i < entry.length() && entry.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String entry) {
        int i;
        for (i = entry.length() - 1; i >= 0 && entry.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public static String[] patternFromJson(JsonArray patternArray) {
        String[] strings = new String[patternArray.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = class_3518.method_15287((JsonElement)patternArray.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    public static Map<String, class_1856> keyFromJson(JsonObject keyEntry) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : keyEntry.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), class_1856.method_52177((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", class_1856.field_9017);
        return map;
    }

    public static class_1799 itemStackFromJson(JsonObject stackObject) {
        class_1792 item = ShapedTesselatingRecipe.itemFromJson(stackObject);
        if (stackObject.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = class_3518.method_15282((JsonObject)stackObject, (String)"count", (int)1);
        if (i < 1) {
            throw new JsonSyntaxException("Invalid output count: " + i);
        }
        return new class_1799((class_1935)item, i);
    }

    public static class_1792 itemFromJson(JsonObject itemObject) {
        String string = class_3518.method_15265((JsonObject)itemObject, (String)"item");
        class_1792 item = (class_1792)class_7923.field_41178.method_17966(new class_2960(string)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + string + "'"));
        if (item == class_1802.field_8162) {
            throw new JsonSyntaxException("Invalid item: " + string);
        }
        return item;
    }

    @Override
    public int weavingTime() {
        return this.weavingTime;
    }

    public static class Serializer
    implements class_1865<ShapedTesselatingRecipe> {
        @NotNull
        public ShapedTesselatingRecipe fromJson(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
            String string = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            Map<String, class_1856> map = ShapedTesselatingRecipe.keyFromJson(class_3518.method_15296((JsonObject)json, (String)"key"));
            String[] strings = ShapedTesselatingRecipe.shrink(ShapedTesselatingRecipe.patternFromJson(class_3518.method_15261((JsonObject)json, (String)"pattern")));
            int i = strings[0].length();
            int j = strings.length;
            class_2371<class_1856> nonNullList = ShapedTesselatingRecipe.dissolvePattern(strings, map, i, j);
            class_1799 itemStack = ShapedTesselatingRecipe.itemStackFromJson(class_3518.method_15296((JsonObject)json, (String)"result"));
            int weavingTime = class_3518.method_15282((JsonObject)json, (String)"weavingtime", (int)200);
            boolean bl = class_3518.method_15258((JsonObject)json, (String)"show_notification", (boolean)true);
            return new ShapedTesselatingRecipe(recipeId, string, i, j, nonNullList, itemStack, weavingTime, bl);
        }

        @NotNull
        public ShapedTesselatingRecipe fromNetwork(@NotNull class_2960 recipeId, class_2540 buffer) {
            int i = buffer.method_10816();
            int j = buffer.method_10816();
            String string = buffer.method_19772();
            class_2371 nonNullList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
            nonNullList.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            class_1799 itemStack = buffer.method_10819();
            int weavingTime = buffer.readInt();
            boolean bl = buffer.readBoolean();
            return new ShapedTesselatingRecipe(recipeId, string, i, j, (class_2371<class_1856>)nonNullList, itemStack, weavingTime, bl);
        }

        public void toNetwork(class_2540 buffer, ShapedTesselatingRecipe recipe) {
            buffer.method_10804(recipe.width);
            buffer.method_10804(recipe.height);
            buffer.method_10814(recipe.group);
            recipe.recipeItems.forEach(ingredient -> ingredient.method_8088(buffer));
            buffer.method_10793(recipe.result);
            buffer.writeInt(recipe.weavingTime);
            buffer.writeBoolean(recipe.showNotification);
        }
    }
}

