/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.rift.targets.IdMarker;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class RiftManager {
    private final Map<Integer, RiftBlockEntity> map;
    private final List<RiftBlockEntity> rifts;
    private final Pocket pocket;
    private int maxId;

    public RiftManager(Pocket pocket, boolean skipGatheringRifts) {
        this.pocket = pocket;
        if (skipGatheringRifts) {
            this.map = new HashMap<Integer, RiftBlockEntity>();
            this.rifts = new ArrayList<RiftBlockEntity>();
            return;
        }
        this.rifts = pocket.getBlockEntities().values().stream().filter(RiftBlockEntity.class::isInstance).map(RiftBlockEntity.class::cast).collect(Collectors.toList());
        this.map = this.rifts.stream().filter(a -> a.getData().getDestination() instanceof IdMarker).filter(a -> ((IdMarker)a.getData().getDestination()).getId() >= 0).collect(Collectors.toMap(rift -> ((IdMarker)rift.getData().getDestination()).getId(), rift -> rift));
        this.maxId = this.map.keySet().stream().mapToInt(a -> a).max().orElse(-1);
    }

    public RiftManager(Pocket pocket) {
        this(pocket, false);
    }

    public boolean add(RiftBlockEntity rift) {
        this.rifts.add(rift);
        if (rift.getData().getDestination() instanceof IdMarker) {
            int id = ((IdMarker)rift.getData().getDestination()).getId();
            if (id < 0) {
                return false;
            }
            this.map.put(id, rift);
            this.maxId = Math.max(id, this.maxId);
            return true;
        }
        return false;
    }

    public boolean consume(int id, Predicate<RiftBlockEntity> consumer) {
        if (this.map.containsKey(id) && consumer.test(this.map.get(id))) {
            this.map.remove(id);
            return true;
        }
        return false;
    }

    public Pocket getPocket() {
        return this.pocket;
    }

    public int nextId() {
        return this.maxId + 1;
    }

    public boolean available(int id) {
        return !this.map.containsKey(id);
    }

    public void foreachConsume(BiPredicate<Integer, RiftBlockEntity> consumer) {
        for (int id : new HashSet<Integer>(this.map.keySet())) {
            if (!consumer.test(id, this.map.get(id))) continue;
            this.map.remove(id);
        }
    }

    public Optional<RiftBlockEntity> get(int id) {
        return Optional.ofNullable(this.map.get(id));
    }

    public List<RiftBlockEntity> getRifts() {
        return this.rifts;
    }

    public boolean isPocketLazy() {
        return this.pocket instanceof LazyGenerationPocket;
    }
}

