/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import com.google.common.collect.Multimap;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.ReferenceSerializable;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.modifier.AbsoluteRiftBlockEntityModifier;
import org.dimdev.dimdoors.pockets.modifier.DimensionalDoorModifier;
import org.dimdev.dimdoors.pockets.modifier.OffsetModifier;
import org.dimdev.dimdoors.pockets.modifier.PocketEntranceModifier;
import org.dimdev.dimdoors.pockets.modifier.RelativeReferenceModifier;
import org.dimdev.dimdoors.pockets.modifier.RiftDataModifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.pockets.modifier.ShellModifier;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public interface Modifier
extends ReferenceSerializable {
    public static final Registrar<ModifierType<? extends Modifier>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("modifier_type"), (Object[])new ModifierType[0]).build();
    public static final String RESOURCE_STARTING_PATH = "pockets/modifier";

    public static Modifier deserialize(class_2520 nbt, class_3300 manager) {
        return switch (nbt.method_10711()) {
            case 10 -> Modifier.deserialize((class_2487)nbt, manager);
            case 8 -> ResourceUtil.loadReferencedResource(manager, RESOURCE_STARTING_PATH, nbt.method_10714(), ResourceUtil.NBT_READER.andThenComposable(Tag -> Modifier.deserialize(Tag, manager)));
            default -> throw new RuntimeException(String.format("Unexpected NbtType %d!", nbt.method_10711()));
        };
    }

    public static Modifier deserialize(class_2520 nbt) {
        return Modifier.deserialize(nbt, null);
    }

    public static Modifier deserialize(class_2487 nbt, class_3300 manager) {
        class_2960 id = class_2960.method_12829((String)nbt.method_10558("type"));
        return ((ModifierType)REGISTRY.get(id)).fromNbt(nbt, manager);
    }

    public static Modifier deserialize(class_2487 nbt) {
        return Modifier.deserialize(nbt, null);
    }

    public static class_2520 serialize(Modifier modifier, boolean allowReference) {
        return modifier.toNbt(new class_2487(), allowReference);
    }

    public static class_2520 serialize(Modifier modifier) {
        return Modifier.serialize(modifier, false);
    }

    public Modifier fromNbt(class_2487 var1, class_3300 var2);

    default public Modifier fromNbt(class_2487 nbt) {
        return this.fromNbt(nbt, null);
    }

    default public class_2520 toNbt(class_2487 nbt, boolean allowReference) {
        return this.getType().toNbt(nbt);
    }

    default public class_2520 toNbt(class_2487 nbt) {
        return this.toNbt(nbt, false);
    }

    public void setResourceKey(String var1);

    public String getResourceKey();

    @Override
    default public void processFlags(Multimap<String, String> flags) {
        Collection reference = flags.get((Object)"reference");
        if (reference.stream().findFirst().map(string -> string.equals("local") || string.equals("global")).orElse(false).booleanValue()) {
            this.setResourceKey(flags.get((Object)"resource_key").stream().findFirst().orElse(null));
        }
    }

    public ModifierType<? extends Modifier> getType();

    public String getKey();

    public void apply(PocketGenerationContext var1, RiftManager var2);

    public void apply(PocketGenerationContext var1, Pocket.PocketBuilder<?, ?> var2);

    public static interface ModifierType<T extends Modifier> {
        public static final RegistrySupplier<ModifierType<ShellModifier>> SHELL_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("shell"), ShellModifier::new);
        public static final RegistrySupplier<ModifierType<DimensionalDoorModifier>> DIMENSIONAL_DOOR_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("door"), DimensionalDoorModifier::new);
        public static final RegistrySupplier<ModifierType<Modifier>> PUBLIC_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("pocket_entrance"), PocketEntranceModifier::new);
        public static final RegistrySupplier<ModifierType<RiftDataModifier>> RIFT_DATA_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("rift_data"), RiftDataModifier::new);
        public static final RegistrySupplier<ModifierType<RelativeReferenceModifier>> RELATIVE_REFERENCE_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("relative"), RelativeReferenceModifier::new);
        public static final RegistrySupplier<ModifierType<OffsetModifier>> OFFSET_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("offset"), OffsetModifier::new);
        public static final RegistrySupplier<ModifierType<Modifier>> ABSOLUTE_RIFT_BLOCK_ENTITY_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("block_entity"), AbsoluteRiftBlockEntityModifier::new);

        public Modifier fromNbt(class_2487 var1, class_3300 var2);

        default public Modifier fromNbt(class_2487 nbt) {
            return this.fromNbt(nbt, null);
        }

        public class_2487 toNbt(class_2487 var1);

        public static void register() {
        }

        public static <U extends Modifier> RegistrySupplier<ModifierType<U>> register(final class_2960 id, final Supplier<U> factory) {
            return REGISTRY.register(id, () -> new ModifierType<U>(){

                @Override
                public Modifier fromNbt(class_2487 nbt, class_3300 manager) {
                    return ((Modifier)factory.get()).fromNbt(nbt, manager);
                }

                @Override
                public class_2487 toNbt(class_2487 nbt) {
                    nbt.method_10582("type", id.toString());
                    return nbt;
                }
            });
        }
    }
}

