/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.block.entity.MutableBlockEntityType;
import org.dimdev.dimdoors.api.util.NbtEquations;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.block.entity.RiftData;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.modifier.AbstractLazyCompatibleModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.rift.targets.IdMarker;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class DimensionalDoorModifier
extends AbstractLazyCompatibleModifier {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "door";
    private class_2350 facing;
    private String doorTypeString;
    private DimensionalDoorBlock doorType;
    private class_2487 doorData;
    private String doorDataReference;
    private String x;
    private String y;
    private String z;
    private Equation xEquation;
    private Equation yEquation;
    private Equation zEquation;

    @Override
    public Modifier fromNbt(class_2487 nbt, class_3300 manager) {
        String facingString = nbt.method_10558("facing");
        this.facing = class_2350.method_10168((String)nbt.method_10558("facing"));
        if (this.facing == null || this.facing.method_10166().method_10178()) {
            throw new RuntimeException("Could not interpret facing direction \"" + facingString + "\"");
        }
        this.doorTypeString = nbt.method_10558("door_type");
        class_2248 doorBlock = (class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)this.doorTypeString));
        if (!(doorBlock instanceof DimensionalDoorBlock)) {
            throw new RuntimeException("Could not interpret door type \"" + this.doorTypeString + "\"");
        }
        this.doorType = (DimensionalDoorBlock)doorBlock;
        if (nbt.method_10540("rift_data") == 8) {
            this.doorDataReference = nbt.method_10558("rift_data");
            this.doorData = PocketLoader.getInstance().getDataNbtCompound(this.doorDataReference);
        } else if (nbt.method_10540("rift_data") == 10) {
            this.doorData = nbt.method_10562("rift_data");
        }
        try {
            this.x = nbt.method_10558("x");
            this.y = nbt.method_10558("y");
            this.z = nbt.method_10558("z");
            this.xEquation = Equation.parse(this.x);
            this.yEquation = Equation.parse(this.y);
            this.zEquation = Equation.parse(this.z);
        }
        catch (Equation.EquationParseException e) {
            LOGGER.error((Object)e);
        }
        return this;
    }

    @Override
    public class_2487 toNbtInternal(class_2487 nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        nbt.method_10582("facing", this.facing.method_15434());
        nbt.method_10582("door_type", this.doorTypeString);
        if (this.doorDataReference != null) {
            nbt.method_10582("rift_data", this.doorDataReference);
        } else if (this.doorData != null) {
            nbt.method_10566("rift_data", (class_2520)this.doorData);
        }
        nbt.method_10582("x", this.x);
        nbt.method_10582("y", this.y);
        nbt.method_10582("z", this.z);
        return nbt;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("facing", (Object)this.facing).add("doorTypeString", (Object)this.doorTypeString).add("doorType", (Object)this.doorType).add("doorData", (Object)this.doorData).add("doorDataReference", (Object)this.doorDataReference).add("x", (Object)this.x).add("y", (Object)this.y).add("z", (Object)this.z).add("xEquation", (Object)this.xEquation).add("yEquation", (Object)this.yEquation).add("zEquation", (Object)this.zEquation).toString();
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return (Modifier.ModifierType)Modifier.ModifierType.DIMENSIONAL_DOOR_MODIFIER_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
        Map<String, Double> variableMap = manager.getPocket().toVariableMap(new HashMap<String, Double>());
        class_2338 pocketOrigin = manager.getPocket().getOrigin();
        class_2338 pos = new class_2338((int)(this.xEquation.apply(variableMap) + (double)pocketOrigin.method_10263()), (int)(this.yEquation.apply(variableMap) + (double)pocketOrigin.method_10264()), (int)(this.zEquation.apply(variableMap) + (double)pocketOrigin.method_10260()));
        class_2680 lower = (class_2680)((class_2680)this.doorType.method_9564().method_11657((class_2769)DimensionalDoorBlock.field_10946, (Comparable)class_2756.field_12607)).method_11657((class_2769)DimensionalDoorBlock.field_10938, (Comparable)this.facing);
        class_2680 upper = (class_2680)((class_2680)this.doorType.method_9564().method_11657((class_2769)DimensionalDoorBlock.field_10946, (Comparable)class_2756.field_12609)).method_11657((class_2769)DimensionalDoorBlock.field_10938, (Comparable)this.facing);
        EntranceRiftBlockEntity rift = (EntranceRiftBlockEntity)((MutableBlockEntityType)((Object)ModBlockEntityTypes.ENTRANCE_RIFT.get())).method_11032(pos, lower);
        rift.method_31662((class_1937)parameters.world());
        if (this.doorData == null) {
            rift.setDestination(new IdMarker(manager.nextId()));
        } else {
            class_2487 solvedDoorData = NbtEquations.solveNbtCompoundEquations(this.doorData, variableMap);
            rift.setData(RiftData.fromNbt(solvedDoorData));
        }
        manager.add(rift);
        if (manager.getPocket() instanceof LazyGenerationPocket) {
            this.queueChunkModificationTask(new class_1923(pos), chunk -> {
                chunk.method_12010(pos, lower, false);
                chunk.method_12007((class_2586)rift);
            });
            this.queueChunkModificationTask(new class_1923(pos.method_10084()), chunk -> chunk.method_12010(pos.method_10084(), upper, false));
        } else {
            class_3218 world = parameters.world();
            world.method_8501(pos, lower);
            world.method_8501(pos.method_10084(), upper);
            world.method_8438((class_2586)rift);
        }
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
    }
}

