/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3341;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.BlockBoxUtil;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.modifier.AbstractLazyModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class AbsoluteRiftBlockEntityModifier
extends AbstractLazyModifier {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "block_entity";
    private Map<class_2338, RiftBlockEntity> rifts;
    private Map<class_2338, class_2487> serializedRifts;

    public AbsoluteRiftBlockEntityModifier() {
    }

    public AbsoluteRiftBlockEntityModifier(Map<class_2338, RiftBlockEntity> rifts) {
        this.rifts = rifts;
    }

    @Override
    public Modifier fromNbt(class_2487 nbt, class_3300 manager) {
        this.serializedRifts = ((Stream)nbt.method_10554("rifts", 10).parallelStream().unordered()).map(class_2487.class::cast).filter(compound -> {
            if (compound.method_10545("Pos")) {
                return true;
            }
            LOGGER.error("Discarding rift on deserialization since \"Pos\" tag was not set.");
            return false;
        }).collect(Collectors.toConcurrentMap(compound -> {
            int[] ints = compound.method_10561("Pos");
            return new class_2338(ints[0], ints[1], ints[2]);
        }, compound -> compound));
        return this;
    }

    @Override
    public class_2487 toNbtInternal(class_2487 nbt, boolean allowResource) {
        class_2499 riftsNbt;
        super.toNbtInternal(nbt, allowResource);
        if (this.rifts != null) {
            riftsNbt = ((Stream)this.rifts.values().parallelStream().unordered()).map(rift -> {
                class_2487 e = new class_2487();
                rift.method_11007(e);
                return e;
            }).collect(Collectors.toCollection(class_2499::new));
        } else {
            riftsNbt = new class_2499();
            riftsNbt.addAll(this.serializedRifts.values());
        }
        nbt.method_10566("rifts", (class_2520)riftsNbt);
        return nbt;
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return (Modifier.ModifierType)Modifier.ModifierType.ABSOLUTE_RIFT_BLOCK_ENTITY_MODIFIER_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
        if (!manager.isPocketLazy()) {
            class_3218 world = DimensionalDoors.getWorld(manager.getPocket().getWorld());
            this.rifts.values().forEach(arg_0 -> ((class_3218)world).method_8438(arg_0));
        }
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
    }

    @Override
    public void applyToChunk(LazyGenerationPocket pocket, class_2791 chunk) {
        class_3341 chunkBox = BlockBoxUtil.getBox(chunk);
        if (this.rifts != null) {
            ((Stream)this.rifts.entrySet().stream().unordered()).filter(entry -> chunkBox.method_14662((class_2382)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach((pos, rift) -> {
                this.rifts.remove(pos);
                chunk.method_12007((class_2586)rift);
            });
        } else {
            ((Stream)this.serializedRifts.entrySet().stream().unordered()).filter(entry -> chunkBox.method_14662((class_2382)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach((pos, riftNbt) -> {
                this.rifts.remove(pos);
                chunk.method_12007(class_2586.method_11005((class_2338)pos, (class_2680)chunk.method_8320(pos), (class_2487)riftNbt));
            });
        }
    }
}

