/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2839;
import net.minecraft.class_2843;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3227;
import net.minecraft.class_3233;
import net.minecraft.class_3300;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_6748;
import net.minecraft.class_7138;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.rift.targets.PocketEntranceMarker;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class ChunkGenerator
extends PocketGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "chunk";
    private class_2960 dimensionID;
    private class_2382 size;
    private int virtualYOffset;

    @Override
    public PocketGenerator fromNbt(class_2487 nbt, class_3300 manager) {
        super.fromNbt(nbt, manager);
        this.dimensionID = new class_2960(nbt.method_10558("dimension_id"));
        int[] temp = nbt.method_10561("size");
        this.size = new class_2382(temp[0], temp[1], temp[2]);
        this.virtualYOffset = nbt.method_10545("virtual_y_offset") ? nbt.method_10550("virtual_y_offset") : 0;
        return this;
    }

    @Override
    public class_2487 toNbtInternal(class_2487 nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        nbt.method_10582("dimension_id", this.dimensionID.toString());
        nbt.method_10539("size", new int[]{this.size.method_10263(), this.size.method_10264(), this.size.method_10260()});
        nbt.method_10569("virtual_y_offset", this.virtualYOffset);
        return nbt;
    }

    @Override
    public Pocket prepareAndPlacePocket(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        class_3218 world = parameters.world();
        VirtualLocation sourceVirtualLocation = parameters.sourceVirtualLocation();
        int chunkSizeX = (this.size.method_10263() >> 4) + (this.size.method_10263() % 16 == 0 ? 0 : 1);
        int chunkSizeZ = (this.size.method_10260() >> 4) + (this.size.method_10260() % 16 == 0 ? 0 : 1);
        Object pocket = DimensionalRegistry.getPocketDirectory((class_5321<class_1937>)world.method_27983()).newPocket(builder);
        LOGGER.info("Generating chunk pocket at location " + String.valueOf(((Pocket)pocket).getOrigin()));
        class_3218 genWorld = DimensionalDoors.getWorld((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.dimensionID));
        class_2794 genWorldChunkGenerator = genWorld.method_14178().method_12129();
        class_7138 config = class_7138.method_41556((class_5284)class_5284.method_44323(), (class_7871)world.method_30349().method_30530(class_7924.field_41244).method_46771(), (long)world.method_8412());
        ArrayList<class_2791> protoChunks = new ArrayList<class_2791>();
        for (int z = 0; z < chunkSizeZ; ++z) {
            for (int x = 0; x < chunkSizeX; ++x) {
                class_2791 protoChunk = new class_2839(new class_1923(((Pocket)pocket).getOrigin().method_10069(x * 16, 0, z * 16)), class_2843.field_12950, (class_5539)world, genWorld.method_30349().method_30530(class_7924.field_41236), null);
                protoChunk.method_17032(genWorld.method_22336());
                protoChunks.add(protoChunk);
            }
        }
        ChunkRegionHack protoRegion = new ChunkRegionHack(genWorld, protoChunks);
        for (class_2791 protoChunk : protoChunks) {
            genWorldChunkGenerator.method_16129(genWorld.method_30349(), genWorld.method_14178().method_46642(), genWorld.method_27056(), protoChunk, genWorld.method_14183());
            ((class_2839)protoChunk).method_12308(class_2806.field_16423);
        }
        for (class_2791 protoChunk : protoChunks) {
            genWorldChunkGenerator.method_16130((class_5281)protoRegion, genWorld.method_27056().method_29951((class_3233)protoRegion), protoChunk);
            ((class_2839)protoChunk).method_12308(class_2806.field_16422);
        }
        for (class_2791 protoChunk : protoChunks) {
            genWorldChunkGenerator.method_38275((Executor)class_156.method_18349(), config, class_6748.method_39336(), genWorld.method_27056(), protoChunk);
            ((class_2839)protoChunk).method_12308(class_2806.field_12794);
        }
        for (class_2791 protoChunk : protoChunks) {
            try {
                genWorldChunkGenerator.method_12088((Executor)class_156.method_18349(), class_6748.method_39336(), config, genWorld.method_27056().method_29951((class_3233)protoRegion), protoChunk).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            ((class_2839)protoChunk).method_12308(class_2806.field_12804);
        }
        for (class_2791 protoChunk : protoChunks) {
            genWorldChunkGenerator.method_12110((class_3233)protoRegion, genWorld.method_27056(), config, protoChunk);
            ((class_2839)protoChunk).method_12308(class_2806.field_12796);
        }
        for (class_2893.class_2894 carver : class_2893.class_2894.values()) {
            for (class_2791 protoChunk : protoChunks) {
                genWorldChunkGenerator.method_12108((class_3233)protoRegion, genWorld.method_8412(), config, genWorld.method_22385(), genWorld.method_27056(), protoChunk, carver);
                class_2839 pChunk = (class_2839)protoChunk;
                if (pChunk.method_12009() == class_2806.field_12796) {
                    pChunk.method_12308(class_2806.field_12801);
                    continue;
                }
                pChunk.method_12308(class_2806.field_12801);
            }
        }
        for (class_2791 protoChunk : protoChunks) {
            ChunkRegionHack tempRegion = new ChunkRegionHack(genWorld, class_1923.method_19280((class_1923)protoChunk.method_12004(), (int)10).map(chunkPos -> protoRegion.method_8392(chunkPos.field_9181, chunkPos.field_9180)).collect(Collectors.toList()));
            genWorldChunkGenerator.method_12102((class_5281)tempRegion, protoChunk, genWorld.method_27056().method_29951((class_3233)tempRegion));
            ((class_2839)protoChunk).method_12308(class_2806.field_12795);
        }
        for (class_2791 protoChunk : protoChunks) {
            ((class_3227)genWorld.method_22336()).method_17310(protoChunk, false);
            ((class_2839)protoChunk).method_12308(class_2806.field_12805);
        }
        for (class_2791 protoChunk : protoChunks) {
            ChunkRegionHack tempRegion = new ChunkRegionHack(genWorld, class_1923.method_19280((class_1923)protoChunk.method_12004(), (int)5).map(chunkPos -> protoRegion.method_8392(chunkPos.field_9181, chunkPos.field_9180)).collect(Collectors.toList()));
            genWorldChunkGenerator.method_12107((class_3233)tempRegion);
            ((class_2839)protoChunk).method_12308(class_2806.field_12786);
        }
        class_2338 firstCorner = ((Pocket)pocket).getOrigin();
        class_2338 secondCorner = new class_2338(firstCorner.method_10263() + this.size.method_10263() - 1, Math.min(firstCorner.method_10264() + this.size.method_10264() - 1, world.method_31605() - this.virtualYOffset - 1), firstCorner.method_10260() + this.size.method_10260() - 1);
        class_2338 pocketOriginChunkOffset = new class_1923(((Pocket)pocket).getOrigin()).method_8323().method_10059((class_2382)firstCorner);
        for (Object blockPos : class_2338.method_10097((class_2338)firstCorner, (class_2338)secondCorner)) {
            class_2338 sourcePos = blockPos.method_10081((class_2382)pocketOriginChunkOffset).method_10069(0, this.virtualYOffset, 0);
            class_2680 blockState = protoRegion.method_8320(sourcePos);
            if (blockState.method_26215()) continue;
            world.method_8501((class_2338)blockPos, protoRegion.method_8320(blockPos.method_10081((class_2382)pocketOriginChunkOffset).method_10069(0, this.virtualYOffset, 0)));
        }
        class_238 realBox = new class_238(firstCorner, secondCorner);
        for (class_2791 protoChunk : protoChunks) {
            for (class_2338 virtualBlockPos : protoChunk.method_12021()) {
                class_2338 realBlockPos = virtualBlockPos.method_10059((class_2382)pocketOriginChunkOffset).method_10069(0, -this.virtualYOffset, 0);
                if (!realBox.method_1008((double)realBlockPos.method_10263(), (double)realBlockPos.method_10264(), (double)realBlockPos.method_10260())) continue;
                world.method_8438(protoChunk.method_8321(virtualBlockPos));
            }
        }
        class_238 virtualBox = realBox.method_996(pocketOriginChunkOffset.method_10069(0, this.virtualYOffset, 0));
        world.method_8501(world.method_8598(class_2902.class_2903.field_13203, ((Pocket)pocket).getOrigin()), ((class_2248)ModBlocks.DETACHED_RIFT.get()).method_9564());
        DetachedRiftBlockEntity rift = (DetachedRiftBlockEntity)((class_2591)ModBlockEntityTypes.DETACHED_RIFT.get()).method_11032(world.method_8598(class_2902.class_2903.field_13203, ((Pocket)pocket).getOrigin()), ((class_2248)ModBlocks.DETACHED_RIFT.get()).method_9564());
        world.method_8438((class_2586)rift);
        rift.setDestination(new PocketEntranceMarker());
        ((Pocket)pocket).virtualLocation = sourceVirtualLocation;
        return pocket;
    }

    @Override
    public PocketGenerator.PocketGeneratorType<? extends PocketGenerator> getType() {
        return (PocketGenerator.PocketGeneratorType)PocketGenerator.PocketGeneratorType.CHUNK.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public class_2382 getSize(PocketGenerationContext parameters) {
        return this.size;
    }

    private static class ChunkRegionHack
    extends class_3233 {
        ChunkRegionHack(class_3218 world, List<class_2791> chunks) {
            super(world, chunks, class_2806.field_12798, 0);
        }

        public class_2791 method_8402(int chunkX, int chunkZ, class_2806 leastStatus, boolean create) {
            class_2791 chunk = super.method_8402(chunkX, chunkZ, leastStatus, false);
            return chunk == null ? new ProtoChunkHack(new class_1923(chunkX, chunkZ), class_2843.field_12950, (class_5539)this, (class_2378<class_1959>)this.method_30349().method_30530(class_7924.field_41236)) : chunk;
        }
    }

    private static class ProtoChunkHack
    extends class_2839 {
        public ProtoChunkHack(class_1923 pos, class_2843 upgradeData, class_5539 world, class_2378<class_1959> biomeRegistry) {
            super(pos, upgradeData, world, biomeRegistry, null);
        }

        public class_2680 method_12010(class_2338 pos, class_2680 state, boolean moved) {
            return class_2246.field_10243.method_9564();
        }

        public class_2680 method_8320(class_2338 pos) {
            return class_2246.field_10243.method_9564();
        }

        public class_3610 method_8316(class_2338 pos) {
            return class_3612.field_15906.method_15785();
        }
    }
}

