/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.listener.pocket;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import org.dimdev.dimdoors.api.util.math.GridUtil;
import org.dimdev.dimdoors.network.client.ClientPacketHandler;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class PocketListenerUtil {
    public static <T> List<T> applicableAddons(Class<T> clazz, class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            throw new UnsupportedOperationException("Cannot call this method on the Client.");
        }
        if (!ModDimensions.isPocketDimension(world)) {
            return Collections.emptyList();
        }
        Pocket pocket = DimensionalRegistry.getPocketDirectory((class_5321<class_1937>)world.method_27983()).getPocketAt(pos);
        if (pocket == null) {
            return Collections.emptyList();
        }
        return pocket.getAddonsInstanceOf(clazz);
    }

    @Environment(value=EnvType.CLIENT)
    public static <T> List<T> applicableAddonsClient(Class<T> clazz, class_1937 world, class_2338 pos) {
        ClientPacketHandler packetHandler = ClientPacketHandler.getHandler();
        if (!world.method_27983().equals(packetHandler.getPocketWorld())) {
            return Collections.emptyList();
        }
        int pocketId = GridUtil.gridPosToID(new GridUtil.GridPos(pos, packetHandler.getGridSize()));
        if (pocketId < packetHandler.getPocketId() || pocketId >= packetHandler.getPocketId() + packetHandler.getPocketRange()) {
            return Collections.emptyList();
        }
        return packetHandler.getAddons().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }
}

