/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item.door;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.item.door.data.RiftDataList;

public final class DoorRiftDataLoader
implements class_4013 {
    private static final DoorRiftDataLoader INSTANCE = new DoorRiftDataLoader();
    private static final Logger LOGGER = LogManager.getLogger((String)"DoorRiftDataLoader");
    private static final Gson GSON = new GsonBuilder().create();
    private final Map<class_1792, RiftDataList> itemRiftData = new HashMap<class_1792, RiftDataList>();

    public static DoorRiftDataLoader getInstance() {
        return INSTANCE;
    }

    private DoorRiftDataLoader() {
    }

    public RiftDataList getRiftData(class_1792 item) {
        return this.itemRiftData.get(item);
    }

    public void method_14491(class_3300 manager) {
        this.itemRiftData.clear();
        Map resources = manager.method_14488("door/data", id -> id.method_12832().endsWith(".json"));
        resources.forEach((id, resource) -> {
            String name = id.method_12832().substring(id.method_12832().lastIndexOf(47) + 1, id.method_12832().lastIndexOf(46));
            class_2960 itemId = new class_2960(id.method_12836(), name);
            if (!class_7923.field_41178.method_10250(itemId)) {
                LOGGER.error("Could not find item " + String.valueOf(itemId) + " for door data " + String.valueOf(id));
                return;
            }
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
            try {
                JsonArray json = (JsonArray)GSON.fromJson((Reader)resource.method_43039(), JsonArray.class);
                RiftDataList dataList = RiftDataList.fromJson(json);
                this.itemRiftData.put(item, dataList);
            }
            catch (IOException e) {
                LOGGER.error("Could not read door data " + String.valueOf(id), (Throwable)e);
            }
        });
    }
}

