/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item.door;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1765;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2533;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.function.TriFunction;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.door.DimensionalTrapdoorBlock;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.client.UnderlaidChildItemRenderer;
import org.dimdev.dimdoors.item.ItemExtensions;
import org.dimdev.dimdoors.item.ModItems;
import org.dimdev.dimdoors.item.door.DimensionalDoorItem;
import org.dimdev.dimdoors.item.door.DimensionalTrapdoorItem;
import org.dimdev.dimdoors.item.door.DoorRiftDataLoader;
import org.dimdev.dimdoors.item.door.data.RiftDataList;
import org.dimdev.dimdoors.rift.targets.EscapeTarget;
import org.dimdev.dimdoors.rift.targets.PublicPocketTarget;
import org.joml.Quaternionf;

public class DimensionalDoorItemRegistrar {
    public static final String PREFIX = "item_ag_dim_";
    private final Registrar<class_1792> registry;
    private final Map<class_2248, class_2248> blocksAlreadyNotifiedAbout = new HashMap<class_2248, class_2248>();
    private final Map<class_2248, Triple<class_2960, class_1792, Function<class_2248, class_1747>>> toBeMapped = new HashMap<class_2248, Triple<class_2960, class_1792, Function<class_2248, class_1747>>>();
    private final Map<class_1792, Function<class_1750, class_1269>> placementFunctions = new HashMap<class_1792, Function<class_1750, class_1269>>();

    public DimensionalDoorItemRegistrar() {
        this.registry = RegistrarManager.get((String)"dimdoors").get(class_7924.field_41197);
        if (Platform.isFabric()) {
            this.init();
        }
        RegistrarManager.get((String)"dimdoors").forRegistry(class_7924.field_41197, registrar -> new ArrayList<Map.Entry>(registrar.entrySet()).forEach(entry -> this.handleEntry((Registrar<class_1792>)registrar, ((class_5321)entry.getKey()).method_29177(), (class_1792)entry.getValue())));
    }

    public boolean isRegistered(class_1792 item) {
        return this.placementFunctions.containsKey(item);
    }

    public class_1269 place(class_1792 item, class_1750 context) {
        return this.placementFunctions.get(item).apply(context);
    }

    private void init() {
        new ArrayList<Map.Entry>(this.registry.entrySet()).forEach(entry -> this.handleEntry(this.registry, ((class_5321)entry.getKey()).method_29177(), (class_1792)entry.getValue()));
    }

    public void handleEntry(Registrar<class_1792> registrar, class_2960 identifier, class_1792 original) {
        if (DimensionalDoors.getConfig().getDoorsConfig().isAllowed(identifier)) {
            class_2248 originalBlock;
            if (original instanceof class_1765) {
                class_1765 doubleHighBlockItem = (class_1765)original;
                class_2248 block = doubleHighBlockItem.method_7711();
                this.handleEntry(registrar, identifier, original, block, AutoGenDimensionalDoorItem::new);
            } else if (original instanceof class_1747 && (originalBlock = ((class_1747)original).method_7711()) instanceof class_2323) {
                this.handleEntry(registrar, identifier, original, originalBlock, AutoGenDimensionalDoorItem::new);
            }
        }
    }

    private void handleEntry(Registrar<class_1792> registrar, class_2960 identifier, class_1792 original, class_2248 originalBlock, TriFunction<class_2248, class_1792.class_1793, class_1792, ? extends class_1747> constructor) {
        if (!(originalBlock instanceof DimensionalDoorBlock) && !(originalBlock instanceof DimensionalTrapdoorBlock) && (originalBlock instanceof class_2323 || originalBlock instanceof class_2533)) {
            class_1792.class_1793 settings = ItemExtensions.getSettings(original).arch$tab(ModItems.DIMENSIONAL_DOORS);
            Function<class_2248, class_1747> dimItemConstructor = dimBlock -> (class_1747)constructor.apply((class_2248)dimBlock, settings, original);
            if (!this.blocksAlreadyNotifiedAbout.containsKey(originalBlock)) {
                this.toBeMapped.put(originalBlock, (Triple<class_2960, class_1792, Function<class_2248, class_1747>>)new ImmutableTriple((Object)identifier, (Object)original, dimItemConstructor));
                return;
            }
            this.register(registrar, identifier, original, this.blocksAlreadyNotifiedAbout.get(originalBlock), dimItemConstructor);
        }
    }

    public void notifyBlockMapped(class_2248 original, class_2248 dimBlock) {
        if (!this.toBeMapped.containsKey(original)) {
            this.blocksAlreadyNotifiedAbout.put(original, dimBlock);
            return;
        }
        Triple<class_2960, class_1792, Function<class_2248, class_1747>> triple = this.toBeMapped.get(original);
        this.register(this.registry, (class_2960)triple.getLeft(), (class_1792)triple.getMiddle(), dimBlock, (Function)triple.getRight());
    }

    private void register(Registrar<class_1792> registrar, class_2960 identifier, class_1792 original, class_2248 block, Function<class_2248, class_1747> dimItem) {
        class_2960 gennedId = DimensionalDoors.id(PREFIX + identifier.method_12836() + "_" + identifier.method_12832());
        class_1747 item = (class_1747)registrar.register(gennedId, () -> (class_1747)dimItem.apply(block)).get();
        this.placementFunctions.put(original, arg_0 -> ((class_1747)item).method_7712(arg_0));
        if (Platform.getEnvironment() == Env.CLIENT) {
            this.registerItemRenderer(item);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void registerItemRenderer(class_1747 dimItem) {
    }

    public static interface ChildItem {
        public class_1792 getOriginalItem();

        default public void transform(class_4587 matrices) {
        }
    }

    private static class AutoGenDimensionalTrapdoorItem
    extends DimensionalTrapdoorItem
    implements ChildItem {
        private final class_1792 originalItem;

        public AutoGenDimensionalTrapdoorItem(class_2248 block, class_1792.class_1793 settings, class_1792 originalItem) {
            super(block, settings, null);
            this.originalItem = originalItem;
        }

        @Override
        protected void setupRift(EntranceRiftBlockEntity entranceRift) {
            RiftDataList data = DoorRiftDataLoader.getInstance().getRiftData(this.originalItem);
            if (data != null) {
                RiftDataList.OptRiftData riftData = data.getRiftData(entranceRift);
                entranceRift.setDestination(riftData.getDestination());
                riftData.getProperties().ifPresent(entranceRift::setProperties);
            } else {
                entranceRift.setDestination(new EscapeTarget(true));
            }
        }

        public class_5250 getName(class_1799 stack) {
            return class_2561.method_43471((String)"dimdoors.autogen_item_prefix").method_27693(this.originalItem.method_7876());
        }

        @Override
        public class_1792 getOriginalItem() {
            return this.originalItem;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void transform(class_4587 matrices) {
            matrices.method_22905(0.55f, 0.55f, 0.6f);
            matrices.method_22904(0.05, -0.05, 0.41);
            matrices.method_22907(new Quaternionf().rotateXYZ(90.0f, 0.0f, 0.0f));
        }
    }

    private static class AutoGenDimensionalDoorItem
    extends DimensionalDoorItem
    implements ChildItem {
        private final class_1792 originalItem;

        public AutoGenDimensionalDoorItem(class_2248 block, class_1792.class_1793 settings, class_1792 originalItem) {
            super(block, settings, null);
            this.originalItem = originalItem;
        }

        @Override
        public void setupRift(EntranceRiftBlockEntity entranceRift) {
            RiftDataList data = DoorRiftDataLoader.getInstance().getRiftData(this.originalItem);
            if (data != null) {
                RiftDataList.OptRiftData riftData = data.getRiftData(entranceRift);
                entranceRift.setDestination(riftData.getDestination());
                riftData.getProperties().ifPresent(entranceRift::setProperties);
            } else {
                entranceRift.setDestination(new PublicPocketTarget());
            }
        }

        public class_5250 getName(class_1799 stack) {
            return class_2561.method_43471((String)"dimdoors.autogen_item_prefix").method_10852(this.originalItem.method_7848());
        }

        @Override
        public class_1792 getOriginalItem() {
            return this.originalItem;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static interface Renderer {
        public static final UnderlaidChildItemRenderer RENDERER = new UnderlaidChildItemRenderer(class_1802.field_8634);
    }
}

