/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.RotatedLocation;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.RiftProvider;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.client.ToolTipHelper;
import org.dimdev.dimdoors.rift.targets.RiftReference;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.world.ModDimensions;

public class RiftSignatureItem
extends class_1792 {
    public static final String ID = "rift_signature";
    public boolean shouldclear;

    public RiftSignatureItem(class_1792.class_1793 settings, boolean clear) {
        super(settings);
        this.shouldclear = clear;
    }

    public boolean method_7886(class_1799 stack) {
        return stack.method_7969() != null && stack.method_7969().method_10545("destination");
    }

    public class_1269 method_7884(class_1838 itemUsageContext) {
        class_1657 player = itemUsageContext.method_8036();
        class_1937 world = itemUsageContext.method_8045();
        class_2338 pos = itemUsageContext.method_8037();
        class_1268 hand = itemUsageContext.method_20287();
        class_2680 state = world.method_8320(pos);
        class_2350 side = itemUsageContext.method_8038();
        class_1799 stack = player.method_5998(hand);
        PlacementLogic placedRiftLogic = PlacementLogic.getLogic(world, pos);
        if (placedRiftLogic == null) {
            pos = pos.method_10093(side);
            placedRiftLogic = PlacementLogic.getLogic(world, pos);
        }
        if (!player.method_7343(pos, side.method_10153(), stack) || placedRiftLogic == null) {
            return class_1269.field_5814;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        if (ModDimensions.isPrivatePocketDimension(world) && !DimensionalDoors.getConfig().getPocketsConfig().canUseRiftSignatureInPrivatePockets) {
            player.method_7353((class_2561)class_2561.method_43471((String)"tools.signature_blocked").method_27692(class_124.field_1074), true);
            return class_1269.field_5814;
        }
        RotatedLocation target = RiftSignatureItem.getSource(stack);
        if (target == null) {
            RiftSignatureItem.setSource(stack, new RotatedLocation((class_5321<class_1937>)world.method_27983(), pos, player.method_36454(), 0.0f));
            player.method_7353((class_2561)class_2561.method_43471((String)(this.method_7876() + ".stored")), true);
            world.method_8396(null, player.method_24515(), (class_3414)ModSoundEvents.RIFT_START.get(), class_3419.field_15245, 0.6f, 1.0f);
        } else {
            RotatedLocation source = new RotatedLocation((class_5321<class_1937>)world.method_27983(), pos, player.method_36454(), 0.0f);
            if (placedRiftLogic != null) {
                placedRiftLogic.getRift((class_3218)world, pos).ifPresent(a -> a.setDestination(RiftReference.tryMakeRelative(source, target)));
            }
            if ((placedRiftLogic = PlacementLogic.getLogic((class_1937)target.getWorld(), target.pos)) != null) {
                placedRiftLogic.getRift(target.getWorld(), target.pos).ifPresent(a -> a.setDestination(RiftReference.tryMakeRelative(target, source)));
            }
            stack.method_7956(1, (class_1309)player, a -> {});
            if (this.shouldclear) {
                RiftSignatureItem.clearSource(stack);
            }
            player.method_7353((class_2561)class_2561.method_43471((String)(this.method_7876() + ".created")), true);
            world.method_8396(null, player.method_24515(), (class_3414)ModSoundEvents.RIFT_END.get(), class_3419.field_15245, 0.6f, 1.0f);
        }
        return class_1269.field_5812;
    }

    public static void setSource(class_1799 itemStack, RotatedLocation destination) {
        if (!itemStack.method_7985()) {
            itemStack.method_7980(new class_2487());
        }
        itemStack.method_7969().method_10566("destination", (class_2520)RotatedLocation.serialize(destination));
    }

    public static void clearSource(class_1799 itemStack) {
        if (itemStack.method_7985()) {
            itemStack.method_7969().method_10551("destination");
        }
    }

    public static RotatedLocation getSource(class_1799 itemStack) {
        if (itemStack.method_7985() && itemStack.method_7969().method_10545("destination")) {
            return RotatedLocation.deserialize(itemStack.method_7969().method_10562("destination"));
        }
        return null;
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> list, class_1836 tooltipContext) {
        RotatedLocation transform = RiftSignatureItem.getSource(itemStack);
        if (transform != null) {
            list.add((class_2561)class_2561.method_43469((String)(this.method_7876() + ".bound.info0"), (Object[])new Object[]{transform.getX(), transform.getY(), transform.getZ(), transform.getWorldId().method_29177()}));
            list.add((class_2561)class_2561.method_43469((String)(this.method_7876() + ".bound.info1"), (Object[])new Object[]{transform.getWorldId().method_29177()}));
        } else {
            ToolTipHelper.processTranslation(list, this.method_7876() + ".unbound.info", new Object[0]);
        }
    }

    public static enum PlacementLogic {
        CREATE((world, pos) -> {
            world.method_8501(pos, ((class_2248)ModBlocks.DETACHED_RIFT.get()).method_9564());
            DetachedRiftBlockEntity rift2 = (DetachedRiftBlockEntity)world.method_8321(pos);
            rift2.register();
            return Optional.of(rift2);
        }),
        EXISTING((serverLevel, blockPos) -> {
            Optional optional;
            class_2680 state = serverLevel.method_8320(blockPos);
            class_2248 patt0$temp = state.method_26204();
            if (patt0$temp instanceof RiftProvider) {
                RiftProvider provider = (RiftProvider)patt0$temp;
                optional = Optional.ofNullable(provider.getRift((class_1937)serverLevel, (class_2338)blockPos, state));
            } else {
                optional = Optional.empty();
            }
            return optional;
        }),
        DOOR((serverLevel, blockPos) -> {
            class_2680 state = serverLevel.method_8320(blockPos);
            class_2248 patt0$temp = state.method_26204();
            if (patt0$temp instanceof class_2323) {
                class_2323 door = (class_2323)patt0$temp;
                Object patt1$temp = class_7923.field_41175.method_10223(DimensionalDoors.getDimensionalDoorBlockRegistrar().get(door.arch$registryName()));
                if (patt1$temp instanceof DimensionalDoorBlock) {
                    DimensionalDoorBlock dimensionalDoorBlock = (DimensionalDoorBlock)patt1$temp;
                    class_2680 dimdoorState = (class_2680)((class_2680)((class_2680)((class_2680)dimensionalDoorBlock.method_9564().method_11657((class_2769)class_2323.field_10941, (Comparable)((class_2750)state.method_11654((class_2769)class_2323.field_10941)))).method_11657((class_2769)class_2323.field_10938, (Comparable)((class_2350)state.method_11654((class_2769)class_2323.field_10938)))).method_11657((class_2769)class_2323.field_10945, (Comparable)((Boolean)state.method_11654((class_2769)class_2323.field_10945)))).method_11657((class_2769)class_2323.field_10940, (Comparable)((Boolean)state.method_11654((class_2769)class_2323.field_10945)));
                    class_2338 top = state.method_11654((class_2769)DimensionalDoorBlock.field_10946) == class_2756.field_12609 ? blockPos : blockPos.method_10084();
                    class_2338 bottom = top.method_10074();
                    serverLevel.method_8501(top, (class_2680)((class_2680)dimdoorState.method_11657((class_2769)DimensionalDoorBlock.field_10946, (Comparable)class_2756.field_12609)).method_11657((class_2769)DimensionalDoorBlock.WATERLOGGED, (Comparable)((Boolean)serverLevel.method_8320(top).method_11654((class_2769)DimensionalDoorBlock.WATERLOGGED))));
                    serverLevel.method_8501(bottom, (class_2680)((class_2680)dimdoorState.method_11657((class_2769)DimensionalDoorBlock.field_10946, (Comparable)class_2756.field_12607)).method_11657((class_2769)DimensionalDoorBlock.WATERLOGGED, (Comparable)((Boolean)serverLevel.method_8320(bottom).method_11654((class_2769)DimensionalDoorBlock.WATERLOGGED))));
                    return Optional.ofNullable(((RiftProvider)serverLevel.method_8321(bottom)).getRift((class_1937)serverLevel, bottom, serverLevel.method_8320(bottom)));
                }
            }
            return Optional.empty();
        });

        private BiFunction<class_3218, class_2338, Optional<RiftBlockEntity>> function;

        private PlacementLogic(BiFunction<class_3218, class_2338, Optional<RiftBlockEntity>> function) {
            this.function = function;
        }

        public Optional<RiftBlockEntity> getRift(class_3218 world, class_2338 pos) {
            return this.function.apply(world, pos);
        }

        public static PlacementLogic getLogic(class_1937 world, class_2338 pos) {
            class_2680 state = world.method_8320(pos);
            if (state.method_45474()) {
                return CREATE;
            }
            if (state.method_26204() instanceof RiftProvider) {
                return EXISTING;
            }
            if (state.method_26204() instanceof class_2323) {
                return DOOR;
            }
            return null;
        }
    }
}

