/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.datagen;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7798;
import net.minecraft.class_7923;
import org.dimdev.dimdoors.recipe.ModRecipeSerializers;

public class TesselatingShapelessRecipeBuilder
extends class_7798
implements class_5797 {
    private final class_1792 result;
    private final int count;
    private final List<class_1856> ingredients = Lists.newArrayList();
    private final class_161.class_162 advancement = class_161.class_162.method_51698();
    @Nullable
    private String group;
    private int weavingTime = 200;

    public TesselatingShapelessRecipeBuilder(class_1935 result, int count) {
        this.result = result.method_8389();
        this.count = count;
    }

    public static TesselatingShapelessRecipeBuilder shapeless(class_1935 result) {
        return new TesselatingShapelessRecipeBuilder(result, 1);
    }

    public static TesselatingShapelessRecipeBuilder shapeless(class_1935 result, int count) {
        return new TesselatingShapelessRecipeBuilder(result, count);
    }

    public TesselatingShapelessRecipeBuilder requires(class_6862<class_1792> tag) {
        return this.requires(class_1856.method_8106(tag));
    }

    public TesselatingShapelessRecipeBuilder weavingTime(int weavingTime) {
        this.weavingTime = weavingTime;
        return this;
    }

    public TesselatingShapelessRecipeBuilder requires(class_1935 item) {
        return this.requires(item, 1);
    }

    public TesselatingShapelessRecipeBuilder requires(class_1935 item, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.requires(class_1856.method_8091((class_1935[])new class_1935[]{item}));
        }
        return this;
    }

    public TesselatingShapelessRecipeBuilder requires(class_1856 ingredient) {
        return this.requires(ingredient, 1);
    }

    public TesselatingShapelessRecipeBuilder requires(class_1856 ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public TesselatingShapelessRecipeBuilder unlockedBy(String criterionName, class_184 criterionTrigger) {
        this.advancement.method_709(criterionName, criterionTrigger);
        return this;
    }

    public TesselatingShapelessRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    public void method_17972(Consumer<class_2444> finishedRecipeConsumer, class_2960 recipeId) {
        recipeId = recipeId.method_45138("tesselating/");
        this.ensureValid(recipeId);
        this.advancement.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_193.field_1257);
        finishedRecipeConsumer.accept(new Result(recipeId, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancement, recipeId.method_45138("recipes/tesselating/"), this.weavingTime));
    }

    private void ensureValid(class_2960 id) {
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final class_1792 result;
        private final int count;
        private final String group;
        private final List<class_1856> ingredients;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;
        private final int weavingTime;

        public Result(class_2960 id, class_1792 result, int count, String group, List<class_1856> ingredients, class_161.class_162 advancement, class_2960 advancementId, int weavingTime) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.ingredients = ingredients;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.weavingTime = weavingTime;
        }

        public void method_10416(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonArray = new JsonArray();
            for (class_1856 ingredient : this.ingredients) {
                jsonArray.add(ingredient.method_8089());
            }
            json.add("ingredients", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", class_7923.field_41178.method_10221((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
            json.addProperty("weavingtime", (Number)this.weavingTime);
        }

        public class_1865<?> method_17800() {
            return (class_1865)ModRecipeSerializers.SHAPELESS_TESSELATING.get();
        }

        public class_2960 method_10417() {
            return this.id;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

