/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5281;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.BlockPlacementType;
import org.dimdev.dimdoors.command.WorldeditHelper;
import org.dimdev.dimdoors.command.arguments.BlockPlacementTypeArgumentType;
import org.dimdev.dimdoors.command.arguments.PocketTemplateArgumentType;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.PocketTemplate;
import org.dimdev.dimdoors.util.schematic.SchematicPlacer;

public class PocketCommand {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<UUID, class_2168> logSetting = new HashMap<UUID, class_2168>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pocket").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"schematic").then(class_2170.method_9247((String)"place").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pocket_template", (ArgumentType)new PocketTemplateArgumentType()).executes(ctx -> PocketCommand.place(((class_2168)ctx.getSource()).method_9207(), PocketTemplateArgumentType.getValue(ctx, "pocket_template"), BlockPlacementType.SECTION_NO_UPDATE))).then(class_2170.method_9244((String)"placement_type", (ArgumentType)new BlockPlacementTypeArgumentType()).executes(ctx -> PocketCommand.place(((class_2168)ctx.getSource()).method_9207(), PocketTemplateArgumentType.getValue(ctx, "pocket_template"), BlockPlacementTypeArgumentType.getBlockPlacementType((CommandContext<class_2168>)ctx, "placement_type"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"load").requires(source -> Platform.isModLoaded((String)"worldedit"))).then(class_2170.method_9244((String)"pocket_template", (ArgumentType)new PocketTemplateArgumentType()).executes(ctx -> PocketCommand.load((class_2168)ctx.getSource(), PocketTemplateArgumentType.getValue(ctx, "pocket_template"))))))).then(class_2170.method_9247((String)"log").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"creation").requires(commandSource -> commandSource.method_9228() instanceof class_3222)).executes(ctx -> {
            class_2168 commandSource = (class_2168)ctx.getSource();
            UUID playerUUID = commandSource.method_9207().method_5667();
            if (logSetting.containsKey(playerUUID)) {
                logSetting.remove(playerUUID);
                commandSource.method_9226(() -> class_2561.method_43471((String)"commands.pocket.log.creation.off"), false);
            } else {
                logSetting.put(playerUUID, commandSource);
                commandSource.method_9226(() -> class_2561.method_43471((String)"commands.pocket.log.creation.on"), false);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"dump").requires(src -> src.method_9259(4))).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Dumping pocket data"), false);
            CompletableFuture.runAsync(() -> {
                try {
                    PocketLoader.getInstance().dump();
                }
                catch (Exception e) {
                    LOGGER.error("Error dumping pocket data", (Throwable)e);
                }
            }).thenRun(() -> ((class_2168)ctx.getSource()).method_9211().execute(() -> ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Dumped pocket data"), false)));
            return 1;
        })));
    }

    private static int load(class_2168 source, PocketTemplate template) throws CommandSyntaxException {
        try {
            return WorldeditHelper.load(source, template);
        }
        catch (NoClassDefFoundError e) {
            return 0;
        }
    }

    private static int place(class_3222 source, PocketTemplate template, BlockPlacementType blockPlacementType) throws CommandSyntaxException {
        SchematicPlacer.place(template.getSchematic(), (class_5281)source.method_51469(), source.method_24515(), blockPlacementType);
        String id = template.getId().toString();
        source.method_7353((class_2561)class_2561.method_43469((String)"commands.pocket.placedSchem", (Object[])new Object[]{id, source.method_24515().method_10263() + ", " + source.method_24515().method_10264() + ", " + source.method_24515().method_10260(), source.method_37908().method_27983().method_29177().toString()}), true);
        return 1;
    }
}

