/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client;

import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_4002;
import net.minecraft.class_5617;
import net.minecraft.class_5944;
import net.minecraft.class_707;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.ModConfig;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.client.DetachedRiftBlockEntityRenderer;
import org.dimdev.dimdoors.client.EntranceRiftBlockEntityRenderer;
import org.dimdev.dimdoors.client.ModShaders;
import org.dimdev.dimdoors.client.MonolithRenderer;
import org.dimdev.dimdoors.client.screen.TesselatingLoomScreen;
import org.dimdev.dimdoors.entity.ModEntityTypes;
import org.dimdev.dimdoors.network.client.ClientPacketHandler;
import org.dimdev.dimdoors.network.packet.c2s.NetworkHandlerInitializedC2SPacket;
import org.dimdev.dimdoors.particle.ModParticleTypes;
import org.dimdev.dimdoors.particle.client.LimboAshParticle;
import org.dimdev.dimdoors.particle.client.MonolithParticle;
import org.dimdev.dimdoors.particle.client.RiftParticle;
import org.dimdev.dimdoors.screen.ModScreenHandlerTypes;

@Environment(value=EnvType.CLIENT)
public class DimensionalDoorsClient {
    private static final ConfigEntryBuilder ENTRY_BUILDER = ConfigEntryBuilder.create();
    public static final class_2960 childItem = DimensionalDoors.id("item/child_item");

    public static void init() {
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(handler -> ClientPacketHandler.sendPacket(new NetworkHandlerInitializedC2SPacket()));
        MenuRegistry.registerScreenFactory((class_3917)((class_3917)ModScreenHandlerTypes.TESSELATING_LOOM.get()), TesselatingLoomScreen::new);
        DimensionalDoorsClient.initBlockEntitiesClient();
        ModBlocks.initClient();
        AutoConfig.getGuiRegistry(ModConfig.class).registerPredicateProvider((i18n, field, config, defaults, registry) -> Collections.singletonList(ENTRY_BUILDER.startStrList((class_2561)class_2561.method_43471((String)i18n), ((Set)Utils.getUnsafely((Field)field, (Object)config, (Object)defaults)).stream().toList()).setSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, newValue.stream().collect(Collectors.toSet()))).build()), DimensionalDoorsClient.isSetOfType(new Type[]{String.class}));
        DimensionalDoorsClient.registerListeners();
        ClientPacketHandler.init();
    }

    @Environment(value=EnvType.CLIENT)
    public static void initEntitiesClient(BiConsumer<class_1299, class_5617> consumer) {
        consumer.accept((class_1299)ModEntityTypes.MONOLITH.get(), MonolithRenderer::new);
    }

    @Environment(value=EnvType.CLIENT)
    public static void initBlockEntitiesClient() {
        BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntityTypes.ENTRANCE_RIFT.get()), context -> new EntranceRiftBlockEntityRenderer());
        BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntityTypes.DETACHED_RIFT.get()), ctx -> new DetachedRiftBlockEntityRenderer());
    }

    private static Predicate<Field> isListOfType(Type ... types) {
        return field -> {
            if (List.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType) {
                Type[] args = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                return args.length == 1 && Stream.of(types).anyMatch(type -> Objects.equals(args[0], type));
            }
            return false;
        };
    }

    private static Predicate<Field> isSetOfType(Type ... types) {
        return field -> {
            if (Set.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType) {
                Type[] args = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                return args.length == 1 && Stream.of(types).anyMatch(type -> Objects.equals(args[0], type));
            }
            return false;
        };
    }

    private static void registerListeners() {
        ClientReloadShadersEvent.EVENT.register((provider, sink) -> {
            try {
                sink.registerShader(new class_5944(provider, "dimensional_portal", class_290.field_1592), ModShaders::setDimensionalPortal);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void initParticles(BiConsumer<class_2396<? extends class_2394>, class_707<?>> specialProvider, BiConsumer<class_2396<?>, Function<class_4002, ? extends class_707<? extends class_2394>>> spriteProivder) {
        specialProvider.accept((class_2396<? extends class_2394>)((class_2396)ModParticleTypes.MONOLITH.get()), (particleOptions, clientLevel, x, y, z, g, h, i) -> new MonolithParticle(clientLevel, x, y, z));
        spriteProivder.accept((class_2396)ModParticleTypes.RIFT.get(), RiftParticle.Factory::new);
        spriteProivder.accept((class_2396)ModParticleTypes.LIMBO_ASH.get(), LimboAshParticle.Factory::new);
    }
}

