/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.recipe.ModRecipeTypes;
import org.dimdev.dimdoors.recipe.TesselatingRecipe;
import org.dimdev.dimdoors.screen.TessellatingContainer;
import org.jetbrains.annotations.Nullable;

public class TesselatingLoomBlockEntity
extends class_2586
implements class_3908,
class_1278,
class_1732,
class_1737 {
    public static final int DATA_WEAVING_TIME = 0;
    public static final int DATA_WEAVING_TIME_TOTAL = 1;
    public static final int NUM_DATA_VALUES = 2;
    private static final int[] OUTPUT_SLOTS = new int[]{9};
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int DEFAULT_WEAVE_TIME = 200;
    private static final String INVENTORY_TAG = "Inventory";
    private static final String WEAVE_TIME_TAG = "WeaveTime";
    private static final String WEAVE_TIME_TOTAL_TAG = "WeaveTimeTotal";
    public int weaveTime;
    public int weaveTimeTotal;
    public final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> TesselatingLoomBlockEntity.this.weaveTime;
                case 1 -> TesselatingLoomBlockEntity.this.weaveTimeTotal;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    TesselatingLoomBlockEntity.this.weaveTime = value;
                    break;
                }
                case 1: {
                    TesselatingLoomBlockEntity.this.weaveTimeTotal = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    public class_2371<class_1799> inventory;
    public class_1799 output = class_1799.field_8037;
    private TesselatingRecipe cachedRecipe;
    private final List<TessellatingContainer> openContainers = new ArrayList<TessellatingContainer>();
    private final Object2IntOpenHashMap<class_2960> recipesUsed = new Object2IntOpenHashMap();

    public TesselatingLoomBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntityTypes.TESSELATING_LOOM.get(), pos, state);
        this.inventory = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2487 inventoryTag = new class_2487();
        class_1262.method_5426((class_2487)inventoryTag, this.inventory);
        inventoryTag.method_10566("Output", (class_2520)this.output.method_7953(new class_2487()));
        nbt.method_10566(INVENTORY_TAG, (class_2520)inventoryTag);
        nbt.method_10569(WEAVE_TIME_TAG, this.weaveTime);
        nbt.method_10569(WEAVE_TIME_TOTAL_TAG, this.weaveTimeTotal);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_2487 inventoryTag = nbt.method_10562(INVENTORY_TAG);
        class_1262.method_5426((class_2487)inventoryTag, this.inventory);
        this.output = class_1799.method_7915((class_2487)inventoryTag.method_10562("Output"));
        this.weaveTime = nbt.method_10550(WEAVE_TIME_TAG);
        this.weaveTimeTotal = nbt.method_10550(WEAVE_TIME_TOTAL_TAG);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public TessellatingContainer createMenu(int syncId, class_1661 inv, class_1657 player) {
        return this.createMenu(syncId, inv);
    }

    public TessellatingContainer createMenu(int syncId, class_1661 inv) {
        return new TessellatingContainer(syncId, this, inv, this.dataAccess);
    }

    public int[] method_5494(class_2350 dir) {
        return SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return slot != 9;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 9;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return slot != 9;
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return this.output.method_7960();
    }

    public int method_5439() {
        return 10;
    }

    public class_1799 method_5438(int slot) {
        if (slot < 9) {
            return (class_1799)this.inventory.get(slot);
        }
        if (!this.output.method_7960()) {
            return this.output;
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        if (slot == 9) {
            return this.output.method_7971(amount);
        }
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        if (slot == 9) {
            class_1799 output = this.output;
            this.output = class_1799.field_8037;
            return output;
        }
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot == 9) {
            this.output = stack;
            return;
        }
        this.inventory.set(slot, (Object)stack);
        this.method_5431();
    }

    public void method_5431() {
        super.method_5431();
        for (TessellatingContainer c : this.openContainers) {
            c.method_7609((class_1263)this);
        }
    }

    public boolean method_5443(class_1657 player) {
        return player.method_23312().method_10262((class_2382)this.field_11867) <= 64.0;
    }

    public void method_7683(class_1662 finder) {
        for (class_1799 stack : this.inventory) {
            finder.method_7400(stack);
        }
    }

    public void method_7662(class_1860<?> recipe) {
        if (recipe instanceof TesselatingRecipe) {
            TesselatingRecipe tesselatingRecipe;
            this.cachedRecipe = tesselatingRecipe = (TesselatingRecipe)recipe;
        }
    }

    public class_1860<?> method_7663() {
        return this.cachedRecipe;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    private Optional<? extends TesselatingRecipe> getCurrentRecipe() {
        TesselatingRecipe mapRecipe;
        if (this.field_11863 == null || this.method_5442()) {
            return Optional.empty();
        }
        if (this.cachedRecipe != null && (mapRecipe = this.getRecipe(this.cachedRecipe.method_8114())) != null && mapRecipe.matches(this, this.field_11863)) {
            return Optional.of(this.cachedRecipe);
        }
        return this.getRecipe();
    }

    public <T extends TesselatingRecipe> TesselatingRecipe getRecipe(class_2960 location) {
        class_1863 manager = this.field_11863.method_8433();
        TesselatingRecipe recipe = (TesselatingRecipe)manager.method_17717((class_3956)ModRecipeTypes.SHAPED_TESSELATING.get()).get(location);
        if (recipe == null) {
            recipe = (TesselatingRecipe)manager.method_17717((class_3956)ModRecipeTypes.SHAPELESS_TESSELATING.get()).get(location);
        }
        return recipe;
    }

    public Optional<? extends TesselatingRecipe> getRecipe() {
        class_1863 manager = this.field_11863.method_8433();
        Optional recipe = manager.method_8132((class_3956)ModRecipeTypes.SHAPED_TESSELATING.get(), (class_1263)this, this.field_11863);
        return recipe.isEmpty() ? manager.method_8132((class_3956)ModRecipeTypes.SHAPELESS_TESSELATING.get(), (class_1263)this, this.field_11863) : recipe;
    }

    private int getWeavingTotalTime() {
        return this.getCurrentRecipe().map(TesselatingRecipe::weavingTime).orElse(200);
    }

    public void serverTick() {
        TesselatingRecipe recipe = this.getRecipe().orElse(null);
        if (this.cachedRecipe == null || this.cachedRecipe != recipe) {
            this.cachedRecipe = recipe;
            this.weaveTimeTotal = this.getWeavingTotalTime();
        }
        if (this.cachedRecipe != null) {
            this.tryWeave();
        } else {
            this.tryDecrementCookTime();
        }
    }

    public void tryDecrementCookTime() {
        if (this.weaveTime > 0) {
            this.weaveTime = class_3532.method_15340((int)(this.weaveTime - 2), (int)0, (int)this.weaveTimeTotal);
            this.method_5431();
        }
    }

    private void tryWeave() {
        class_1799 output = this.cachedRecipe.method_8116((class_1263)this, this.field_11863.method_30349());
        if (this.canAcceptOutput(output)) {
            ++this.weaveTime;
            if (this.weaveTime >= this.weaveTimeTotal) {
                this.weaveTime = 0;
                this.cachedRecipe = null;
                this.takeInputs();
                this.insertOutput(output);
            }
            this.method_5431();
        } else {
            this.tryDecrementCookTime();
        }
    }

    private void insertOutput(class_1799 output) {
        if (output.method_7960()) {
            return;
        }
        if (output.method_7946()) {
            for (int slot : OUTPUT_SLOTS) {
                class_1799 existing = this.method_5438(slot);
                if (!existing.method_7960() && class_1799.method_31577((class_1799)output, (class_1799)existing)) {
                    int total = existing.method_7947() + output.method_7947();
                    if (total <= existing.method_7914()) {
                        output.method_7939(0);
                        existing.method_7939(total);
                    } else if (existing.method_7947() < existing.method_7914()) {
                        output.method_7934(existing.method_7914() - existing.method_7947());
                        existing.method_7939(existing.method_7914());
                    }
                }
                if (!output.method_7960()) continue;
                return;
            }
        }
        for (int slot : OUTPUT_SLOTS) {
            if (!this.method_5438(slot).method_7960()) continue;
            this.method_5447(slot, output.method_7971(output.method_7947()));
        }
    }

    private void takeInputs() {
        for (int slot : INPUT_SLOTS) {
            class_1799 stack = this.method_5438(slot);
            class_1792 item = stack.method_7909();
            stack.method_7934(1);
            if (!stack.method_7960()) continue;
            class_1799 newStack = item.method_7858() != null ? new class_1799((class_1935)item.method_7858()) : class_1799.field_8037;
            this.method_5447(slot, newStack);
        }
        this.method_5431();
    }

    private boolean canAcceptOutput(class_1799 output) {
        int remianingOutput = output.method_7947();
        for (int slot : OUTPUT_SLOTS) {
            class_1799 existing = this.method_5438(slot);
            if (existing.method_7960()) {
                return true;
            }
            if (output.method_7946() && class_1799.method_31577((class_1799)existing, (class_1799)output)) {
                if (existing.method_7947() + remianingOutput <= existing.method_7914()) {
                    return true;
                }
                if (existing.method_7947() < existing.method_7914()) {
                    remianingOutput -= existing.method_7914() - existing.method_7947();
                }
            }
            if (remianingOutput != 0) continue;
            return true;
        }
        return false;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38242();
    }

    public void awardUsedRecipesAndPopExperience(class_3222 player) {
        List<class_1860<?>> list = this.getRecipesToAwardAndPopExperience(player.method_51469(), player.method_19538());
        player.method_7254(list);
        this.recipesUsed.clear();
    }

    public List<class_1860<?>> getRecipesToAwardAndPopExperience(class_3218 level, class_243 popVec) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.method_8433().method_8130((class_2960)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                TesselatingLoomBlockEntity.createExperience(level, popVec, entry.getIntValue(), ((class_1874)recipe).method_8171());
            });
        }
        return list;
    }

    private static void createExperience(class_3218 level, class_243 popVec, int recipeIndex, float experience) {
        int i = class_3532.method_15375((float)((float)recipeIndex * experience));
        float f = class_3532.method_22450((float)((float)recipeIndex * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        class_1303.method_31493((class_3218)level, (class_243)popVec, (int)i);
    }
}

