/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.entity;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.rift.target.Target;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RGBA;
import org.dimdev.dimdoors.api.util.math.TransformationMatrix3d;
import org.dimdev.dimdoors.block.CoordinateTransformerBlock;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftData;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.registry.Rift;
import org.dimdev.dimdoors.rift.targets.LocationProvider;
import org.dimdev.dimdoors.rift.targets.MessageTarget;
import org.dimdev.dimdoors.rift.targets.Targets;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.jetbrains.annotations.NotNull;

public abstract class RiftBlockEntity
extends class_2586
implements Target,
EntityTarget {
    private static final Logger LOGGER = LogManager.getLogger();
    public static long showRiftCoreUntil = 0L;
    @NotNull
    protected RiftData data = new RiftData();
    protected boolean riftStateChanged;

    public RiftBlockEntity(class_2591<? extends RiftBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.deserialize(nbt);
    }

    public void deserialize(class_2487 nbt) {
        this.data = RiftData.fromNbt(nbt.method_10562("data"));
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.serialize(nbt);
    }

    public class_2487 serialize(class_2487 nbt) {
        nbt.method_10566("data", (class_2520)RiftData.toNbt(this.data));
        return nbt;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void setDestination(VirtualTarget destination) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting destination {} for {}", (Object)destination, (Object)this.field_11867.method_23854());
        }
        if (this.getDestination() != null && this.isRegistered()) {
            this.getDestination().unregister();
        }
        this.data.setDestination(destination);
        if (destination != null) {
            if (this.field_11863 != null && this.field_11867 != null) {
                destination.setLocation(new Location((class_3218)this.field_11863, this.field_11867));
            }
            if (this.isRegistered()) {
                destination.register();
            }
        }
        this.riftStateChanged = true;
        this.method_5431();
        this.updateColor();
    }

    public void setColor(RGBA color) {
        this.data.setColor(color);
        this.method_5431();
    }

    public void setProperties(LinkProperties properties) {
        this.data.setProperties(properties);
        this.updateProperties();
        this.method_5431();
    }

    public class_2487 method_16887() {
        return super.method_16887();
    }

    public void markStateChanged() {
        this.riftStateChanged = true;
        this.method_5431();
    }

    public boolean isRegistered() {
        return this.field_11863 != null && DimensionalRegistry.getRiftRegistry().isRiftAt(new Location((class_3218)this.field_11863, this.field_11867));
    }

    public void register() {
        if (this.isRegistered()) {
            return;
        }
        Location loc = new Location((class_3218)this.field_11863, this.field_11867);
        DimensionalRegistry.getRiftRegistry().addRift(loc);
        if (this.data.getDestination() != VirtualTarget.NoneTarget.INSTANCE) {
            this.data.getDestination().register();
        }
        this.updateProperties();
        this.updateColor();
    }

    public void updateProperties() {
        if (this.isRegistered()) {
            DimensionalRegistry.getRiftRegistry().setProperties(new Location((class_3218)this.field_11863, this.field_11867), this.data.getProperties());
        }
        this.method_5431();
    }

    public void unregister() {
        if (this.isRegistered()) {
            DimensionalRegistry.getRiftRegistry().removeRift(new Location((class_3218)this.field_11863, this.field_11867));
        }
    }

    public void updateType() {
        if (!this.isRegistered()) {
            return;
        }
        Rift rift = DimensionalRegistry.getRiftRegistry().getRift(new Location((class_3218)this.field_11863, this.field_11867));
        rift.setDetached(this.isDetached());
        rift.markDirty();
    }

    public void handleTargetGone(Location location) {
        if (this.data.getDestination().shouldInvalidate(location)) {
            this.data.setDestination(VirtualTarget.NoneTarget.INSTANCE);
            this.method_5431();
        }
        this.updateColor();
    }

    public void handleSourceGone(Location location) {
        this.updateColor();
    }

    public Target getTarget() {
        if (this.data.getDestination() == VirtualTarget.NoneTarget.INSTANCE) {
            return new MessageTarget("rifts.unlinked1", new Object[0]);
        }
        this.data.getDestination().setLocation(new Location((class_3218)this.field_11863, this.field_11867));
        return this.data.getDestination();
    }

    public boolean teleport(class_1297 entity) {
        this.riftStateChanged = false;
        try {
            Location location;
            class_243 relativePos = new class_243(0.0, 0.0, 0.0);
            class_2379 relativeAngle = new class_2379(entity.method_36455(), entity.method_36454(), 0.0f);
            class_243 relativeVelocity = entity.method_18798();
            Target target = this.getTarget();
            if (target instanceof LocationProvider) {
                LocationProvider provider = (LocationProvider)((Object)target);
                location = provider.getLocation();
            } else {
                location = null;
            }
            Location location2 = location;
            EntityTarget target2 = this.getTarget().as(Targets.ENTITY);
            class_2680 state = this.method_10997().method_8320(this.method_11016());
            class_2248 block = state.method_26204();
            if (block instanceof CoordinateTransformerBlock) {
                CoordinateTransformerBlock transformer = (CoordinateTransformerBlock)block;
                TransformationMatrix3d.TransformationMatrix3dBuilder transformationBuilder = transformer.transformationBuilder(state, this.method_11016());
                TransformationMatrix3d.TransformationMatrix3dBuilder rotatorBuilder = transformer.rotatorBuilder(state, this.method_11016());
                relativePos = transformer.transformTo(transformationBuilder, entity.method_19538());
                relativeAngle = transformer.rotateTo(rotatorBuilder, relativeAngle);
                relativeVelocity = transformer.rotateTo(rotatorBuilder, relativeVelocity);
            }
            if (target2.receiveEntity(entity, relativePos, relativeAngle, relativeVelocity, location2)) {
                VirtualLocation vLoc = VirtualLocation.fromLocation(new Location((class_3218)entity.method_37908(), entity.method_24515()));
                if (DimensionalDoors.getConfig().getGeneralConfig().enableDebugMessages) {
                    EntityUtils.chat(entity, (class_2561)class_2561.method_43470((String)("You are at x = " + vLoc.getX() + ", y = ?, z = " + vLoc.getZ() + ", w = " + vLoc.getDepth())));
                }
                return true;
            }
        }
        catch (Exception e) {
            EntityUtils.chat(entity, (class_2561)class_2561.method_43470((String)"Something went wrong while trying to teleport you, please report this bug."));
            LOGGER.error("Teleporting failed with the following exception: ", (Throwable)e);
        }
        return false;
    }

    public void updateColor() {
        if (this.data.isForcedColor()) {
            return;
        }
        if (!this.isRegistered()) {
            this.data.setColor(new RGBA(0.0f, 0.0f, 0.0f, 1.0f));
        } else if (this.data.getDestination() == VirtualTarget.NoneTarget.INSTANCE) {
            this.data.setColor(new RGBA(0.7f, 0.7f, 0.7f, 1.0f));
        } else {
            this.data.getDestination().setLocation(new Location((class_3218)this.field_11863, this.field_11867));
            RGBA newColor = this.data.getDestination().getColor();
            if (this.data.getColor() == null && newColor != null || !Objects.equals(this.data.getColor(), newColor)) {
                this.data.setColor(newColor);
                this.method_5431();
            }
        }
    }

    public abstract boolean isDetached();

    public abstract void setLocked(boolean var1);

    public abstract boolean isLocked();

    public void copyFrom(DetachedRiftBlockEntity rift) {
        this.data.setDestination(rift.data.getDestination());
        this.data.setProperties(rift.data.getProperties());
        this.data.setAlwaysDelete(rift.data.isAlwaysDelete());
        this.data.setForcedColor(rift.data.isForcedColor());
    }

    public VirtualTarget getDestination() {
        return this.data.getDestination();
    }

    public LinkProperties getProperties() {
        return this.data.getProperties();
    }

    public boolean isAlwaysDelete() {
        return this.data.isAlwaysDelete();
    }

    public boolean isForcedColor() {
        return this.data.isForcedColor();
    }

    public RGBA getColor() {
        return this.data.getColor();
    }

    public void setData(RiftData data) {
        this.data = data;
    }

    public RiftData getData() {
        return this.data;
    }

    public void setWorld(class_1937 level) {
        this.field_11863 = level;
    }

    public Rift asRift() {
        return DimensionalRegistry.getRiftRegistry().getRift(new Location((class_5321<class_1937>)this.field_11863.method_27983(), this.field_11867));
    }
}

