/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5819;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.client.RiftCurves;

public class DetachedRiftBlockEntity
extends RiftBlockEntity {
    private static final class_5819 random = class_5819.method_43047();
    public boolean closing = false;
    public boolean stabilized = false;
    public int spawnedEndermanId = 0;
    public float size = 0.0f;
    public int curveID = (int)(Math.random() * (double)RiftCurves.CURVES.size());
    private boolean unregisterDisabled = false;
    @Environment(value=EnvType.CLIENT)
    public double renderAngle;

    public DetachedRiftBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends RiftBlockEntity>)((class_2591)ModBlockEntityTypes.DETACHED_RIFT.get()), pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, DetachedRiftBlockEntity blockEntity) {
        if (world == null) {
            return;
        }
        if (state.method_26204() != ModBlocks.DETACHED_RIFT.get()) {
            blockEntity.method_11012();
            return;
        }
        if (!world.method_8608() && (double)random.method_43057() < DimensionalDoors.getConfig().getGeneralConfig().endermanSpawnChance) {
            class_1560 enderman = (class_1560)class_1299.field_6091.method_47821((class_3218)world, pos, class_3730.field_16474);
            if (random.method_43058() < DimensionalDoors.getConfig().getGeneralConfig().endermanAggressiveChance && enderman != null) {
                enderman.method_5980((class_1309)world.method_18460((class_1297)enderman, 50.0));
            }
        }
        if (blockEntity.closing) {
            if (blockEntity.size > 0.0f) {
                blockEntity.size = (float)((double)blockEntity.size - DimensionalDoors.getConfig().getGeneralConfig().riftCloseSpeed);
            } else {
                world.method_8650(pos, false);
            }
        } else if (!blockEntity.stabilized) {
            blockEntity.size = (float)((double)blockEntity.size + DimensionalDoors.getConfig().getGeneralConfig().riftGrowthSpeed / (double)(blockEntity.size + 1.0f));
        }
    }

    public void setClosing(boolean closing) {
        this.closing = closing;
        this.method_5431();
    }

    public void setStabilized(boolean stabilized) {
        this.stabilized = stabilized;
        this.method_5431();
    }

    public int getCurveID() {
        return this.curveID;
    }

    @Override
    public class_2487 serialize(class_2487 nbt) {
        super.serialize(nbt);
        nbt.method_10556("closing", this.closing);
        nbt.method_10556("stablized", this.stabilized);
        nbt.method_10569("spawnedEnderManId", this.spawnedEndermanId);
        nbt.method_10548("size", this.size);
        nbt.method_10569("curveID", this.curveID);
        return nbt;
    }

    @Override
    public void deserialize(class_2487 nbt) {
        super.deserialize(nbt);
        this.closing = nbt.method_10577("closing");
        this.stabilized = nbt.method_10577("stablized");
        this.spawnedEndermanId = nbt.method_10550("spawnedEnderManId");
        this.size = nbt.method_10583("size");
        this.curveID = nbt.method_10550("curveID");
    }

    @Override
    public boolean isDetached() {
        return true;
    }

    @Override
    public void unregister() {
        if (!this.unregisterDisabled) {
            super.unregister();
        }
    }

    @Override
    public boolean receiveEntity(class_1297 entity, class_243 relativePos, class_2379 relativeAngle, class_243 velocity, Location location) {
        if (this.field_11863 instanceof class_3218) {
            TeleportUtil.teleport(entity, this.field_11863, this.field_11867, relativeAngle, velocity);
        }
        return true;
    }

    public void setUnregisterDisabled(boolean unregisterDisabled) {
        this.unregisterDisabled = unregisterDisabled;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setLocked(boolean locked) {
    }

    @Override
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        tag.method_10548("size", this.size);
        tag.method_10569("curveID", this.curveID);
        return tag;
    }
}

