/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.door;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2533;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.block.entity.MutableBlockEntityType;
import org.dimdev.dimdoors.block.DoorSoundProvider;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.door.DimensionalTrapdoorBlock;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.item.door.DimensionalDoorItemRegistrar;

public class DimensionalDoorBlockRegistrar {
    public static final String PREFIX = "block_ag_dim_";
    private final Registrar<class_2248> registry;
    private final DimensionalDoorItemRegistrar itemRegistrar;
    private final BiMap<class_2960, class_2960> mappedDoorBlocks = HashBiMap.create();

    public DimensionalDoorBlockRegistrar(DimensionalDoorItemRegistrar itemRegistrar) {
        this.registry = RegistrarManager.get((String)"dimdoors").get(class_7924.field_41254);
        this.itemRegistrar = itemRegistrar;
        if (Platform.isFabric()) {
            this.init();
        }
        RegistrarManager.get((String)"dimdoors").forRegistry(class_7924.field_41254, registrar -> new ArrayList<Map.Entry>(registrar.entrySet()).forEach(entry -> this.handleEntry((Registrar<class_2248>)registrar, ((class_5321)entry.getKey()).method_29177(), (class_2248)entry.getValue())));
        LifecycleEvent.SETUP.register(() -> this.mappedDoorBlocks.keySet().stream().map(arg_0 -> ((class_7922)class_7923.field_41175).method_10223(arg_0)).forEach(a -> ((MutableBlockEntityType)((Object)((Object)((Object)ModBlockEntityTypes.ENTRANCE_RIFT.get())))).addBlock((class_2248)a)));
    }

    private void init() {
        new ArrayList<Map.Entry>(this.registry.entrySet()).forEach(entry -> this.handleEntry(this.registry, ((class_5321)entry.getKey()).method_29177(), (class_2248)entry.getValue()));
    }

    public void handleEntry(Registrar<class_2248> registrar, class_2960 ResourceLocation, class_2248 original) {
        if (DimensionalDoors.getConfig().getDoorsConfig().isAllowed(ResourceLocation)) {
            if (!(original instanceof DimensionalDoorBlock) && original instanceof class_2323) {
                class_2323 doorBlock = (class_2323)original;
                this.register(registrar, ResourceLocation, (DoorSoundProvider)doorBlock, DimensionalDoorBlockRegistrar::createAutoGenDimensionalDoorBlock);
            } else if (!(original instanceof DimensionalTrapdoorBlock) && original instanceof class_2533) {
                class_2533 class_25332 = (class_2533)original;
            }
        }
    }

    private void register(Registrar<class_2248> registrar, class_2960 location, DoorSoundProvider original, BiFunction<class_4970.class_2251, DoorSoundProvider, class_2248> constructor) {
        class_2960 gennedId = DimensionalDoors.id(PREFIX + location.method_12836() + "_" + location.method_12832());
        if (this.mappedDoorBlocks.containsKey((Object)gennedId)) {
            return;
        }
        class_2248 dimBlock = (class_2248)registrar.register(gennedId, () -> (class_2248)constructor.apply(class_4970.class_2251.method_9630((class_4970)((class_4970)original)), original)).get();
        this.mappedDoorBlocks.put((Object)gennedId, (Object)location);
        this.itemRegistrar.notifyBlockMapped((class_2248)original, dimBlock);
        if (Platform.getEnvironment() == Env.CLIENT) {
            this.putCutout(dimBlock);
        }
    }

    private void putCutout(class_2248 original) {
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{original});
    }

    public class_2960 get(class_2960 ResourceLocation) {
        return (class_2960)this.mappedDoorBlocks.get((Object)ResourceLocation);
    }

    public boolean isMapped(class_2960 ResourceLocation) {
        return this.mappedDoorBlocks.containsKey((Object)ResourceLocation);
    }

    private static <T extends Comparable<T>> class_2680 transferProperty(class_2680 from, class_2680 to, class_2769<T> property) {
        return (class_2680)to.method_11657(property, from.method_11654(property));
    }

    private static AutoGenDimensionalDoorBlock createAutoGenDimensionalDoorBlock(class_4970.class_2251 settings, final DoorSoundProvider originalBlock) {
        return new AutoGenDimensionalDoorBlock(settings, originalBlock){

            @Override
            protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
                DimensionalDoorBlockRegistrar.appendPropertiesOverride(builder, (class_2248)originalBlock, new class_2769[]{WATERLOGGED});
            }
        };
    }

    private static AutoGenDimensionalTrapdoorBlock createAutoGenDimensionalTrapdoorBlock(class_4970.class_2251 settings, final DoorSoundProvider originalBlock) {
        return new AutoGenDimensionalTrapdoorBlock(settings, originalBlock){

            @Override
            protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
                DimensionalDoorBlockRegistrar.appendPropertiesOverride(builder, (class_2248)originalBlock, new class_2769[]{field_11626});
            }
        };
    }

    private static void appendPropertiesOverride(class_2689.class_2690<class_2248, class_2680> builder, class_2248 originalBlock, class_2769<?> ... requiredProperties) {
        HashSet properties = new HashSet(originalBlock.method_9595().method_11659());
        properties.addAll(List.of(requiredProperties));
        builder.method_11667(properties.toArray(new class_2769[0]));
    }

    public void forEach() {
    }

    public Set<class_2960> getGennedIds() {
        return this.mappedDoorBlocks.keySet();
    }

    private static class AutoGenDimensionalTrapdoorBlock
    extends DimensionalTrapdoorBlock {
        private final class_2248 originalBlock;

        public AutoGenDimensionalTrapdoorBlock(class_4970.class_2251 settings, DoorSoundProvider originalBlock) {
            super(settings, originalBlock.getSetType());
            this.originalBlock = (class_2248)originalBlock;
            class_2680 state = (class_2680)this.method_9595().method_11664();
            class_2680 originalState = this.originalBlock.method_9564();
            for (class_2769 property : this.originalBlock.method_9564().method_28501()) {
                state = DimensionalDoorBlockRegistrar.transferProperty(originalState, state, property);
            }
            this.method_9590((class_2680)state.method_11657((class_2769)field_11626, (Comparable)Boolean.valueOf(false)));
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            throw new RuntimeException("AutoGenDimensionalTrapdoorBlock should be instantiated as anonymous inner class overriding appendProperties!");
        }

        public class_5250 method_9518() {
            return class_2561.method_43469((String)"dimdoors.autogen_block_prefix", (Object[])new Object[]{this.originalBlock.method_9518()});
        }
    }

    public static class AutoGenDimensionalDoorBlock
    extends DimensionalDoorBlock {
        private final class_2248 originalBlock;

        public AutoGenDimensionalDoorBlock(class_4970.class_2251 settings, DoorSoundProvider originalBlock) {
            super(settings, originalBlock.getSetType());
            this.originalBlock = (class_2248)originalBlock;
            class_2680 state = (class_2680)this.method_9595().method_11664();
            class_2680 originalState = this.originalBlock.method_9564();
            for (class_2769 property : this.originalBlock.method_9564().method_28501()) {
                state = DimensionalDoorBlockRegistrar.transferProperty(originalState, state, property);
            }
            this.method_9590((class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            throw new RuntimeException("AutoGenDimensionalDoorBlock should be instantiated as anonymous inner class overriding appendProperties!");
        }

        public class_5250 method_9518() {
            return class_2561.method_43469((String)"dimdoors.autogen_block_prefix", (Object[])new Object[]{this.originalBlock.method_9518()});
        }

        public class_2248 getOriginalBlock() {
            return this.originalBlock;
        }
    }
}

