/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util.math;

import org.dimdev.dimdoors.api.util.math.Matrixd;

public class Vectord {
    private final double[] vec;

    public Vectord(int size) {
        this.vec = new double[size];
    }

    public Vectord(double ... vec) {
        this.vec = vec;
    }

    protected double[] getVec() {
        return this.vec;
    }

    public double get(int index) {
        return this.vec[index];
    }

    public Vectord set(int index, double value) {
        double[] vec = this.vec;
        vec[index] = value;
        return new Vectord(vec);
    }

    public Vectord drop(int index) {
        double[] vec = new double[this.size() - 1];
        for (int i = 0; i < this.size(); ++i) {
            if (i == index) continue;
            vec[i < index ? i : i - 1] = this.vec[i];
        }
        return new Vectord(vec);
    }

    public Vectord append(double value) {
        double[] extended = new double[this.size() + 1];
        for (int i = 0; i < this.size(); ++i) {
            extended[i] = this.vec[i];
        }
        extended[this.size()] = value;
        return new Vectord(extended);
    }

    public int size() {
        return this.vec.length;
    }

    public Vectord invert() {
        return this.mult(-1.0);
    }

    public Vectord mult(double value) {
        double[] vec = this.vec;
        int i = 0;
        while (i < vec.length) {
            int n = i++;
            vec[n] = vec[n] * value;
        }
        return new Vectord(vec);
    }

    public double dot(Vectord vector) {
        if (vector.size() != this.size()) {
            throw new UnsupportedOperationException("Cannot apply dot product to vectors of different size.");
        }
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            sum += this.get(i) * vector.get(i);
        }
        return sum;
    }

    public Vectord cross(Vectord ... vectors) {
        if (vectors.length != this.size() - 2) {
            throw new UnsupportedOperationException("Cannot perform " + this.size() + "D vector cross product with " + (vectors.length + 1) + " vectors.");
        }
        Vectord[] allVectors = new Vectord[vectors.length + 1];
        allVectors[0] = this;
        for (int i = 0; i < vectors.length; ++i) {
            allVectors[i + 1] = vectors[i];
        }
        Matrixd matrix = (Matrixd)new Matrixd(allVectors).transpose();
        double[] vector = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            vector[i] = (i + this.size()) % 2 == 0 ? ((Matrixd)matrix.dropColumn(i)).determinant() : -((Matrixd)matrix.dropColumn(i)).determinant();
        }
        return new Vectord(vector);
    }
}

